"use client"

import { useEffect, useState } from "react"
import { useRouter } from "next/navigation"
import { AdminLayout } from "@/components/admin/admin-layout"

export default function AdminDashboard() {
  const router = useRouter()
  const [loading, setLoading] = useState(true)

  useEffect(() => {
    const isLoggedIn = localStorage.getItem("adminLoggedIn")
    if (isLoggedIn !== "true") {
      router.push("/admin")
    } else {
      setLoading(false)
    }
  }, [router])

  if (loading) {
    return (
      <div className="min-h-screen bg-gradient-to-br from-slate-900 via-purple-900 to-slate-900 flex items-center justify-center">
        <div className="text-white text-xl">Loading...</div>
      </div>
    )
  }

  return (
    <AdminLayout>
      <div className="space-y-6">
        <div>
          <h1 className="text-3xl font-bold text-white">Admin Dashboard</h1>
          <p className="text-gray-300">Welcome to the Bishop & Knight Insurance Admin Portal</p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
          <div className="bg-white/10 backdrop-blur-lg rounded-lg p-6 border border-white/20">
            <h3 className="text-lg font-semibold text-white mb-2">Total Users</h3>
            <p className="text-3xl font-bold text-purple-400">1,234</p>
            <p className="text-sm text-gray-400">+12% from last month</p>
          </div>

          <div className="bg-white/10 backdrop-blur-lg rounded-lg p-6 border border-white/20">
            <h3 className="text-lg font-semibold text-white mb-2">Active Quotes</h3>
            <p className="text-3xl font-bold text-blue-400">567</p>
            <p className="text-sm text-gray-400">+8% from last month</p>
          </div>

          <div className="bg-white/10 backdrop-blur-lg rounded-lg p-6 border border-white/20">
            <h3 className="text-lg font-semibold text-white mb-2">Revenue</h3>
            <p className="text-3xl font-bold text-green-400">₦2.4M</p>
            <p className="text-sm text-gray-400">+15% from last month</p>
          </div>

          <div className="bg-white/10 backdrop-blur-lg rounded-lg p-6 border border-white/20">
            <h3 className="text-lg font-semibold text-white mb-2">Conversions</h3>
            <p className="text-3xl font-bold text-orange-400">23.5%</p>
            <p className="text-sm text-gray-400">+3% from last month</p>
          </div>
        </div>

        <div className="bg-white/10 backdrop-blur-lg rounded-lg p-6 border border-white/20">
          <h2 className="text-xl font-semibold text-white mb-4">Quick Actions</h2>
          <div className="grid grid-cols-1 md:grid-cols-3 gap-4">
            <button className="p-4 bg-purple-500/20 hover:bg-purple-500/30 rounded-lg border border-purple-500/30 text-white transition-colors">
              <h3 className="font-semibold">Manage Content</h3>
              <p className="text-sm text-gray-300">Edit pages, images, and text</p>
            </button>
            <button className="p-4 bg-blue-500/20 hover:bg-blue-500/30 rounded-lg border border-blue-500/30 text-white transition-colors">
              <h3 className="font-semibold">User Management</h3>
              <p className="text-sm text-gray-300">View and manage users</p>
            </button>
            <button className="p-4 bg-green-500/20 hover:bg-green-500/30 rounded-lg border border-green-500/30 text-white transition-colors">
              <h3 className="font-semibold">System Settings</h3>
              <p className="text-sm text-gray-300">Configure site settings</p>
            </button>
          </div>
        </div>
      </div>
    </AdminLayout>
  )
}
