import type { Metadata } from "next"
import PrivacyPolicyContent from "@/components/privacy-policy-content"
import Header from "@/components/header"
import Footer from "@/components/footer"

export const metadata: Metadata = {
  title: "Privacy Policy | Bishop & Knight Insurance Brokers",
  description:
    "Learn how Bishop & Knight Insurance Brokers collects, uses, and protects your personal information in compliance with Nigerian data protection laws.",
}

export default function PrivacyPolicyPage() {
  return (
    <div className="min-h-screen bg-gradient-to-br from-slate-50 to-blue-50">
      <Header />
      <main>
        <PrivacyPolicyContent />
      </main>
      <Footer />
    </div>
  )
}
