import type { Metadata } from "next"
import ShopHeroSection from "@/components/shop-hero-section"
import ServicesShopSection from "@/components/services-shop-section"
import ShoppingCartProvider from "@/components/shopping-cart-provider"
import Header from "@/components/header"
import Footer from "@/components/footer"

export const metadata: Metadata = {
  title: "Shop Insurance Services | Bishop & Knight Insurance Brokers",
  description:
    "Browse and purchase comprehensive insurance services from Bishop & Knight. Motor, health, property, marine, aviation, and business insurance solutions.",
}

export default function ShopPage() {
  return (
    <ShoppingCartProvider>
      <div className="min-h-screen bg-gradient-to-br from-slate-50 to-blue-50">
        <Header />
        <main>
          <ShopHeroSection />
          <ServicesShopSection />
        </main>
        <Footer />
      </div>
    </ShoppingCartProvider>
  )
}
