import type { Metadata } from "next"
import TermsConditionsContent from "@/components/terms-conditions-content"
import Header from "@/components/header"
import Footer from "@/components/footer"

export const metadata: Metadata = {
  title: "Terms & Conditions | Bishop & Knight Insurance Brokers",
  description:
    "Read the terms and conditions governing the use of Bishop & Knight Insurance Brokers services and website.",
}

export default function TermsConditionsPage() {
  return (
    <div className="min-h-screen bg-gradient-to-br from-slate-50 to-blue-50">
      <Header />
      <main>
        <TermsConditionsContent />
      </main>
      <Footer />
    </div>
  )
}
