"use client"

import { Card, CardContent } from "@/components/ui/card"
import { Button } from "@/components/ui/button"
import { CheckCircle, Target, Eye, Heart, Sparkles, Zap, TrendingUp } from "lucide-react"
import { useEffect, useState } from "react"

export function AboutSection() {
  const [isVisible, setIsVisible] = useState(false)

  useEffect(() => {
    const observer = new IntersectionObserver(
      ([entry]) => {
        if (entry.isIntersecting) {
          setIsVisible(true)
        }
      },
      { threshold: 0.1 },
    )

    const element = document.getElementById("about")
    if (element) observer.observe(element)

    return () => observer.disconnect()
  }, [])

  return (
    <section
      id="about"
      className="py-20 bg-gradient-to-br from-white via-purple-50/30 to-blue-50/30 relative overflow-hidden"
    >
      {/* Background Elements */}
      <div className="absolute inset-0 overflow-hidden">
        <div className="absolute top-20 right-20 w-64 h-64 bg-gradient-to-r from-purple-200/40 to-blue-200/40 rounded-full blur-3xl animate-pulse"></div>
        <div className="absolute bottom-20 left-20 w-48 h-48 bg-gradient-to-r from-cyan-200/40 to-teal-200/40 rounded-full blur-3xl animate-pulse animation-delay-2000"></div>
      </div>

      <div className="container mx-auto px-4 relative z-10">
        <div className="grid lg:grid-cols-2 gap-16 items-center">
          {/* Content */}
          <div
            className={`space-y-8 transition-all duration-1000 ${isVisible ? "opacity-100 translate-x-0" : "opacity-0 -translate-x-10"}`}
          >
            <div className="space-y-6">
              <div className="inline-flex items-center px-4 py-2 bg-gradient-to-r from-purple-100 to-blue-100 text-purple-800 rounded-full text-sm font-medium border border-purple-200/50">
                <Sparkles className="h-4 w-4 mr-2 animate-pulse" />
                About Bishop & Knight
              </div>

              <h2 className="text-4xl lg:text-5xl font-bold leading-tight">
                <span className="bg-gradient-to-r from-purple-600 to-blue-600 bg-clip-text text-transparent">
                  Redefining Insurance
                </span>
                <br />
                <span className="text-slate-900">for Modern Nigeria</span>
              </h2>

              <p className="text-lg text-slate-600 leading-relaxed">
                In today's fast-paced world, we're not just another insurance broker. We're your strategic partner,
                leveraging cutting-edge technology and deep market expertise to deliver personalized protection that
                evolves with your needs.
              </p>
            </div>

            <div className="space-y-6">
              <h3 className="text-2xl font-semibold text-slate-900 flex items-center">
                <Zap className="h-6 w-6 text-purple-600 mr-2" />
                What Makes Us Different
              </h3>

              <div className="grid grid-cols-1 sm:grid-cols-2 gap-4">
                {[
                  { text: "AI-Powered Risk Assessment", icon: TrendingUp },
                  { text: "Instant Digital Quotes", icon: Zap },
                  { text: "24/7 Mobile Claims", icon: CheckCircle },
                  { text: "Personalized Coverage", icon: Heart },
                ].map((item, index) => (
                  <div
                    key={index}
                    className="flex items-center space-x-3 p-3 bg-white/60 backdrop-blur-sm rounded-xl border border-white/50 hover:bg-white/80 transition-all duration-300 group"
                  >
                    <div className="p-2 bg-gradient-to-r from-purple-500 to-blue-500 rounded-lg group-hover:scale-110 transition-transform duration-300">
                      <item.icon className="h-4 w-4 text-white" />
                    </div>
                    <span className="text-slate-700 font-medium">{item.text}</span>
                  </div>
                ))}
              </div>
            </div>

            <Button className="relative overflow-hidden bg-gradient-to-r from-purple-600 to-blue-600 hover:from-purple-700 hover:to-blue-700 text-white px-8 py-3 rounded-full group transition-all duration-300">
              <span className="relative z-10 flex items-center">
                Discover Our Story
                <CheckCircle className="ml-2 h-5 w-5 group-hover:rotate-12 transition-transform duration-300" />
              </span>
              <div className="absolute inset-0 bg-gradient-to-r from-white/20 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
            </Button>
          </div>

          {/* Vision, Mission, Values */}
          <div
            className={`space-y-6 transition-all duration-1000 delay-300 ${isVisible ? "opacity-100 translate-x-0" : "opacity-0 translate-x-10"}`}
          >
            {[
              {
                icon: Eye,
                title: "Our Vision",
                content:
                  "To be Africa's most innovative insurance technology platform, empowering millions with accessible, intelligent protection.",
                gradient: "from-purple-500 to-pink-500",
                bg: "from-purple-50 to-pink-50",
              },
              {
                icon: Target,
                title: "Our Mission",
                content:
                  "Revolutionizing insurance through technology, transparency, and exceptional customer experience while building lasting partnerships across Nigeria.",
                gradient: "from-blue-500 to-cyan-500",
                bg: "from-blue-50 to-cyan-50",
              },
              {
                icon: Heart,
                title: "Our Values",
                content: "Innovation • Integrity • Excellence • Customer-First • Transparency • Continuous Growth",
                gradient: "from-green-500 to-teal-500",
                bg: "from-green-50 to-teal-50",
              },
            ].map((item, index) => (
              <Card
                key={index}
                className={`group hover:shadow-2xl transition-all duration-500 hover:-translate-y-2 border-0 bg-gradient-to-br ${item.bg} backdrop-blur-sm`}
              >
                <CardContent className="p-6">
                  <div className="flex items-start space-x-4">
                    <div
                      className={`p-3 bg-gradient-to-r ${item.gradient} rounded-xl group-hover:scale-110 transition-transform duration-300`}
                    >
                      <item.icon className="h-6 w-6 text-white" />
                    </div>
                    <div className="flex-1">
                      <h3 className="text-xl font-bold text-slate-900 mb-3">{item.title}</h3>
                      <p className="text-slate-600 leading-relaxed">{item.content}</p>
                    </div>
                  </div>
                  <div
                    className={`absolute inset-0 bg-gradient-to-r ${item.gradient} opacity-0 group-hover:opacity-5 rounded-lg transition-opacity duration-300`}
                  ></div>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </div>
    </section>
  )
}
