import { Briefcase, GraduationCap } from "lucide-react"

const executives = [
  {
    name: "Alhaji Rasaki Oladejo",
    position: "Chairman",
    credentials: "FCS",
    image: "/team.png",
    description:
      "Alhaji Rasaki Oladejo is a highly accomplished capital market professional and administrator with extensive experience in economic research, financial markets, and corporate strategy.",
    expertise: ["Capital Markets", "Economic Research", "Financial Markets", "Corporate Strategy"],
    experience: "25+ Years",
  },
  {
    name: "Adetutu Ayantayo",
    position: "Director",
    credentials: "FCS",
    image: "/team.png",
    description:
      "Adetutu Ayantayo is a seasoned stockbroker and asset management professional with extensive experience spanning over three decades.",
    expertise: ["Stockbroking", "Asset Management", "Investment Strategy", "Portfolio Management"],
    experience: "30+ Years",
  },
  {
    name: "Opeyemi Oladejo",
    position: "Managing Director/CEO",
    credentials: "CFA, FCS, FCCA, ACII",
    image: "/team.png",
    description:
      "Opeyemi Oladejo is a results-driven financial services professional with over 15 years of leadership experience across insurance, pensions, stockbroking, and investment management.",
    expertise: ["Insurance Leadership", "Pension Management", "Investment Management", "Strategic Planning"],
    experience: "15+ Years",
  },
]

export function ExecutiveTeamSection() {
  return (
    <section id="executive-team" className="py-20 bg-white">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-16">
          <h2 className="text-4xl md:text-5xl font-bold bg-gradient-to-r from-purple-600 to-blue-600 bg-clip-text text-transparent mb-6">
            Executive Team
          </h2>
          <p className="text-xl text-gray-600 max-w-3xl mx-auto">
            Our leadership team brings decades of combined experience in financial services, insurance, and strategic
            management
          </p>
        </div>

        <div className="space-y-16">
          {executives.map((executive, index) => (
            <div
              key={executive.name}
              className={`flex flex-col ${
                index % 2 === 0 ? "lg:flex-row" : "lg:flex-row-reverse"
              } items-center gap-12 lg:gap-16`}
              style={{ animationDelay: `${index * 200}ms` }}
            >
              {/* Executive Image */}
              <div className="flex-shrink-0">
                <div className="relative group">
                  <div className="absolute -inset-4 bg-gradient-to-r from-purple-500 to-blue-600 rounded-3xl blur opacity-25 group-hover:opacity-40 transition duration-300"></div>
                  <div className="relative w-80 h-80 rounded-3xl overflow-hidden shadow-2xl group-hover:shadow-3xl transition-all duration-300 transform group-hover:scale-105">
                    <img
                      src={executive.image || "/team.png"}
                      alt={executive.name}
                      className="w-full h-full object-cover"
                    />
                    <div className="absolute inset-0 bg-gradient-to-t from-black/20 to-transparent"></div>
                  </div>
                </div>
              </div>

              {/* Executive Details */}
              <div className="flex-1 text-center lg:text-left">
                <div className="mb-6">
                  <h3 className="text-3xl md:text-4xl font-bold text-gray-900 mb-2">{executive.name}</h3>
                  <div className="flex flex-col sm:flex-row items-center justify-center lg:justify-start gap-2 mb-4">
                    <span className="text-xl font-semibold bg-gradient-to-r from-purple-600 to-blue-600 bg-clip-text text-transparent">
                      {executive.position}
                    </span>
                    <span className="hidden sm:block text-gray-400">•</span>
                    <span className="text-lg text-gray-600">{executive.credentials}</span>
                  </div>
                </div>

                <p className="text-lg text-gray-600 mb-8 leading-relaxed">{executive.description}</p>

                <div className="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
                  <div className="bg-gradient-to-br from-purple-50 to-blue-50 rounded-2xl p-6">
                    <div className="flex items-center mb-4">
                      <div className="w-12 h-12 bg-gradient-to-br from-purple-500 to-blue-600 rounded-xl flex items-center justify-center mr-4">
                        <Briefcase className="w-6 h-6 text-white" />
                      </div>
                      <h4 className="text-lg font-semibold text-gray-900">Experience</h4>
                    </div>
                    <p className="text-2xl font-bold bg-gradient-to-r from-purple-600 to-blue-600 bg-clip-text text-transparent">
                      {executive.experience}
                    </p>
                  </div>

                  <div className="bg-gradient-to-br from-purple-50 to-blue-50 rounded-2xl p-6">
                    <div className="flex items-center mb-4">
                      <div className="w-12 h-12 bg-gradient-to-br from-purple-500 to-blue-600 rounded-xl flex items-center justify-center mr-4">
                        <GraduationCap className="w-6 h-6 text-white" />
                      </div>
                      <h4 className="text-lg font-semibold text-gray-900">Expertise</h4>
                    </div>
                    <div className="flex flex-wrap gap-2">
                      {executive.expertise.map((skill, idx) => (
                        <span
                          key={idx}
                          className="px-3 py-1 bg-white rounded-full text-sm font-medium text-gray-700 shadow-sm"
                        >
                          {skill}
                        </span>
                      ))}
                    </div>
                  </div>
                </div>

                <div className="flex flex-col sm:flex-row gap-4 justify-center lg:justify-start">
                  <a
                    href="mailto:info@bishopknight.com"
                    className="px-6 py-3 bg-gradient-to-r from-purple-500 to-blue-600 text-white font-semibold rounded-full hover:shadow-lg transition-all duration-300 transform hover:scale-105"
                  >
                    Contact {executive.name.split(" ")[0]}
                  </a>
                  <a
                    href="tel:+2348012345678"
                    className="px-6 py-3 border-2 border-purple-500 text-purple-600 font-semibold rounded-full hover:bg-purple-500 hover:text-white transition-all duration-300 transform hover:scale-105"
                  >
                    Schedule Meeting
                  </a>
                </div>
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  )
}
