import { Facebook, Twitter, Linkedin, Instagram, Mail, Phone, MapPin, Zap, Shield } from "lucide-react"
import Link from "next/link"

export function Footer() {
  return (
    <footer className="bg-gradient-to-br from-slate-900 via-purple-900 to-blue-900 text-white relative overflow-hidden">
      {/* Background Elements */}
      <div className="absolute inset-0 overflow-hidden">
        <div className="absolute top-20 left-20 w-64 h-64 bg-gradient-to-r from-purple-500/20 to-blue-500/20 rounded-full blur-3xl animate-pulse"></div>
        <div className="absolute bottom-20 right-20 w-72 h-72 bg-gradient-to-r from-cyan-500/20 to-teal-500/20 rounded-full blur-3xl animate-pulse animation-delay-2000"></div>
      </div>

      <div className="container mx-auto px-4 py-16 relative z-10">
        <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
          {/* Company Info */}
          <div className="space-y-6">
            <div className="flex items-center space-x-3">
              <img src="/logo.png" alt="Bishop & Knight Insurance Brokers" className="h-12 w-auto object-contain" />
            </div>
            <p className="text-blue-100 text-sm leading-relaxed">
              Bishop & Knight Insurance Brokers Limited is a fully licensed, technology-driven insurance brokerage firm
              providing customized insurance solutions for individuals, families, and businesses.
            </p>
            <div className="flex space-x-4">
              {[
                { icon: Facebook, href: "#" },
                { icon: Twitter, href: "#" },
                { icon: Linkedin, href: "#" },
                { icon: Instagram, href: "#" },
              ].map((social, index) => (
                <Link
                  key={index}
                  href={social.href}
                  className="p-2 bg-white/10 backdrop-blur-sm rounded-lg text-blue-200 hover:text-white hover:bg-white/20 transition-all duration-300 group"
                >
                  <social.icon className="h-5 w-5 group-hover:scale-110 transition-transform duration-300" />
                </Link>
              ))}
            </div>
          </div>

          {/* Quick Links */}
          <div>
            <h4 className="text-lg font-bold mb-6 bg-gradient-to-r from-purple-400 to-blue-400 bg-clip-text text-transparent">
              Quick Links
            </h4>
            <ul className="space-y-3 text-sm">
              {[
                { href: "/about", label: "About Us" },
                { href: "/services", label: "Our Services" },
                { href: "/shop", label: "Shop Insurance" },
                { href: "/leadership", label: "Leadership" },
                { href: "/contact", label: "Contact Us" },
                { href: "/quote", label: "Get Quote" },
              ].map((link, index) => (
                <li key={index}>
                  <Link
                    href={link.href}
                    className="text-blue-200 hover:text-white transition-colors duration-300 hover:translate-x-1 inline-block"
                  >
                    {link.label}
                  </Link>
                </li>
              ))}
            </ul>
          </div>

          {/* Services */}
          <div>
            <h4 className="text-lg font-bold mb-6 bg-gradient-to-r from-green-400 to-teal-400 bg-clip-text text-transparent">
              Our Services
            </h4>
            <ul className="space-y-3 text-sm">
              {[
                { href: "/services", label: "Motor Insurance" },
                { href: "/services", label: "Health & Life Insurance" },
                { href: "/services", label: "Fire & General Property" },
                { href: "/services", label: "Marine & Aviation" },
                { href: "/services", label: "Professional Indemnity" },
                { href: "/services", label: "Group Life & Benefits" },
              ].map((service, index) => (
                <li key={index}>
                  <Link
                    href={service.href}
                    className="text-blue-200 hover:text-white transition-colors duration-300 hover:translate-x-1 inline-block"
                  >
                    {service.label}
                  </Link>
                </li>
              ))}
            </ul>
          </div>

          {/* Contact Info */}
          <div>
            <h4 className="text-lg font-bold mb-6 bg-gradient-to-r from-orange-400 to-red-400 bg-clip-text text-transparent">
              Contact Info
            </h4>
            <div className="space-y-4 text-sm">
              <div className="flex items-start space-x-3 group">
                <MapPin className="h-4 w-4 text-blue-300 mt-1 flex-shrink-0 group-hover:scale-110 transition-transform duration-300" />
                <span className="text-blue-100">
                  123 Victoria Island, Lagos
                  <br />
                  Lagos State, Nigeria
                </span>
              </div>
              <a
                href="tel:+2348012345678"
                className="flex items-center space-x-3 text-blue-100 hover:text-white transition-colors duration-300 group"
              >
                <Phone className="h-4 w-4 text-blue-300 flex-shrink-0 group-hover:scale-110 transition-transform duration-300" />
                <span>+234 801 234 5678</span>
              </a>
              <a
                href="mailto:info@bishopknight.com"
                className="flex items-center space-x-3 text-blue-100 hover:text-white transition-colors duration-300 group"
              >
                <Mail className="h-4 w-4 text-blue-300 flex-shrink-0 group-hover:scale-110 transition-transform duration-300" />
                <span>info@bishopknight.com</span>
              </a>
            </div>

            {/* Quick Actions */}
            <div className="mt-6 space-y-3">
              <Link href="/quote">
                <button className="w-full bg-gradient-to-r from-purple-600 to-blue-600 hover:from-purple-700 hover:to-blue-700 text-white px-4 py-3 rounded-full text-sm font-semibold transition-all duration-300 group">
                  <Zap className="inline h-4 w-4 mr-2 group-hover:animate-pulse" />
                  Get Instant Quote
                </button>
              </Link>
              <a href="tel:+2348012345678">
                <button className="w-full border border-white/30 hover:bg-white/10 text-white px-4 py-3 rounded-full text-sm font-semibold transition-all duration-300 group backdrop-blur-sm">
                  <Shield className="inline h-4 w-4 mr-2 group-hover:scale-110 transition-transform duration-300" />
                  Call for Support
                </button>
              </a>
            </div>
          </div>
        </div>

        <div className="border-t border-white/20 mt-12 pt-8">
          <div className="flex flex-col md:flex-row justify-between items-center space-y-4 md:space-y-0">
            <p className="text-blue-200 text-sm">
              © 2024 Bishop & Knight Insurance Brokers Limited. All rights reserved. | Licensed by NAICOM
            </p>
            <div className="flex space-x-6 text-sm">
              {[
                { href: "/privacy-policy", label: "Privacy Policy" },
                { href: "/terms-conditions", label: "Terms & Conditions" },
                { href: "/cookie-policy", label: "Cookie Policy" },
              ].map((link, index) => (
                <Link
                  key={index}
                  href={link.href}
                  className="text-blue-200 hover:text-white transition-colors duration-300"
                >
                  {link.label}
                </Link>
              ))}
            </div>
          </div>
        </div>
      </div>
    </footer>
  )
}

export default Footer
