"use client"
import Link from "next/link"
import { Button } from "@/components/ui/button"
import { InfiniteSlider } from "@/components/ui/infinite-slider"
import { ProgressiveBlur } from "@/components/ui/progressive-blur"
import { ChevronRight, Shield, Users, Award } from "lucide-react"

export function HeroSection() {
  return (
    <>
      <main className="overflow-x-hidden">
        <section>
          <div className="py-24 md:pb-32 lg:pb-36 lg:pt-32">
            <div className="relative z-10 mx-auto flex max-w-7xl flex-col px-6 lg:block lg:px-12">
              <div className="mx-auto max-w-lg text-center lg:ml-0 lg:max-w-full lg:text-left">
                <h1 className="mt-8 max-w-2xl text-balance text-5xl md:text-6xl lg:mt-16 xl:text-7xl">
                  <span className="bg-gradient-to-r from-purple-600 via-blue-600 to-cyan-600 bg-clip-text text-transparent">
                    Protecting
                  </span>
                  <br />
                  <span className="text-slate-900">What Matters</span>
                  <br />
                  <span className="bg-gradient-to-r from-pink-500 to-orange-500 bg-clip-text text-transparent">
                    Most
                  </span>
                </h1>
                <p className="mt-8 max-w-2xl text-balance text-lg text-slate-600">
                  Experience the future of insurance with Bishop & Knight's cutting-edge solutions, personalized
                  service, and unmatched protection for the modern Nigerian.
                </p>

                <div className="mt-12 flex flex-col items-center justify-center gap-2 sm:flex-row lg:justify-start">
                  <Button
                    asChild
                    size="lg"
                    className="h-12 rounded-full pl-5 pr-3 text-base bg-gradient-to-r from-purple-600 to-blue-600 hover:from-purple-700 hover:to-blue-700"
                  >
                    <Link href="/quote">
                      <span className="text-nowrap">Get Instant Quote</span>
                      <ChevronRight className="ml-1" />
                    </Link>
                  </Button>
                  <Button
                    key={2}
                    asChild
                    size="lg"
                    variant="ghost"
                    className="h-12 rounded-full px-5 text-base hover:bg-zinc-950/5 dark:hover:bg-white/5"
                  >
                    <Link href="/services">
                      <span className="text-nowrap">Explore Services</span>
                    </Link>
                  </Button>
                </div>

                {/* Modern Stats Cards */}
                <div className="mt-12 grid grid-cols-3 gap-4">
                  {[
                    { number: "15+", label: "Years Experience", color: "from-purple-500 to-pink-500", icon: Award },
                    { number: "5K+", label: "Happy Clients", color: "from-blue-500 to-cyan-500", icon: Users },
                    { number: "24/7", label: "Support", color: "from-green-500 to-teal-500", icon: Shield },
                  ].map((stat, index) => (
                    <div
                      key={index}
                      className="relative p-4 bg-white/80 backdrop-blur-sm rounded-2xl border border-white/50 shadow-lg hover:shadow-xl transition-all duration-300 group hover:-translate-y-1"
                    >
                      <div
                        className={`absolute inset-0 bg-gradient-to-r ${stat.color} opacity-0 group-hover:opacity-10 rounded-2xl transition-opacity duration-300`}
                      ></div>
                      <div className="relative z-10 text-center">
                        <stat.icon
                          className={`h-6 w-6 mx-auto mb-2 bg-gradient-to-r ${stat.color} bg-clip-text text-transparent`}
                        />
                        <div
                          className={`text-2xl font-bold bg-gradient-to-r ${stat.color} bg-clip-text text-transparent`}
                        >
                          {stat.number}
                        </div>
                        <div className="text-xs text-slate-600 font-medium">{stat.label}</div>
                      </div>
                    </div>
                  ))}
                </div>
              </div>
            </div>
            <div className="aspect-[2/3] absolute inset-1 overflow-hidden rounded-3xl border border-black/10 sm:aspect-video lg:rounded-[3rem] dark:border-white/5">
              <video
                autoPlay
                loop
                muted
                className="size-full object-cover opacity-50 invert dark:opacity-35 dark:invert-0 dark:lg:opacity-75"
                src="/hero.mp4"
              />
            </div>
          </div>
        </section>
        <section className="bg-background pb-2">
          <div className="group relative m-auto max-w-7xl px-6">
            <div className="flex flex-col items-center md:flex-row">
              <div className="md:max-w-44 md:border-r md:pr-6">
                <p className="text-end text-sm text-slate-600">Trusted by leading Nigerian businesses</p>
              </div>
              <div className="relative py-6 md:w-[calc(100%-11rem)]">
                <InfiniteSlider speedOnHover={20} speed={40} gap={112}>
                  <div className="flex">
                    <img
                      className="mx-auto h-8 w-fit opacity-60 hover:opacity-100 transition-opacity duration-300"
                      src="/partners/partner1.png"
                      alt="Partner 1"
                      height="32"
                      width="auto"
                    />
                  </div>

                  <div className="flex">
                    <img
                      className="mx-auto h-8 w-fit opacity-60 hover:opacity-100 transition-opacity duration-300"
                      src="/partners/partner2.png"
                      alt="Partner 2"
                      height="32"
                      width="auto"
                    />
                  </div>
                  
                  <div className="flex">
                    <img
                      className="mx-auto h-8 w-fit opacity-60 hover:opacity-100 transition-opacity duration-300"
                      src="/partners/partner3.png"
                      alt="Partner 3"
                      height="32"
                      width="auto"
                    />
                  </div>
                  
                  <div className="flex">
                    <img
                      className="mx-auto h-8 w-fit opacity-60 hover:opacity-100 transition-opacity duration-300"
                      src="/partners/partner4.png"
                      alt="Partner 4"
                      height="32"
                      width="auto"
                    />
                  </div>
                  
                  <div className="flex">
                    <img
                      className="mx-auto h-8 w-fit opacity-60 hover:opacity-100 transition-opacity duration-300"
                      src="/partners/partner5.png"
                      alt="Partner 5"
                      height="32"
                      width="auto"
                    />
                  </div>
                  
                  <div className="flex">
                    <img
                      className="mx-auto h-8 w-fit opacity-60 hover:opacity-100 transition-opacity duration-300"
                      src="/partners/partner6.png"
                      alt="Partner 6"
                      height="32"
                      width="auto"
                    />
                  </div>
                </InfiniteSlider>

                <div className="bg-linear-to-r from-background absolute inset-y-0 left-0 w-20"></div>
                <div className="bg-linear-to-l from-background absolute inset-y-0 right-0 w-20"></div>
                <ProgressiveBlur
                  className="pointer-events-none absolute left-0 top-0 h-full w-20"
                  direction="left"
                  blurIntensity={1}
                />
                <ProgressiveBlur
                  className="pointer-events-none absolute right-0 top-0 h-full w-20"
                  direction="right"
                  blurIntensity={1}
                />
              </div>
            </div>
          </div>
        </section>
      </main>
    </>
  )
}
