import { CheckCircle, Zap, Shield, Users } from "lucide-react"

const benefits = [
  {
    icon: CheckCircle,
    title: "Tailored Solutions",
    description: "We design insurance packages based on your unique needs and risk profile.",
  },
  {
    icon: Users,
    title: "Market Expertise",
    description: "Access to top-tier insurers and sector-specific underwriters for the best coverage.",
  },
  {
    icon: Zap,
    title: "Tech-Driven Services",
    description: "Seamless, automated operations for fast and efficient service delivery.",
  },
  {
    icon: Shield,
    title: "Swift Claims Processing",
    description: "We push for quick and fair settlements when you need them most.",
  },
]

export function ServicesBenefitsSection() {
  return (
    <section className="py-20 bg-gradient-to-br from-purple-50 to-blue-50">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-16">
          <h2 className="text-4xl md:text-5xl font-bold bg-gradient-to-r from-purple-600 to-blue-600 bg-clip-text text-transparent mb-6">
            Why Bishop & Knight?
          </h2>
          <p className="text-xl text-gray-600 max-w-3xl mx-auto">
            We don't just sell insurance — we build tailored insurance solutions that provide real value
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
          {benefits.map((benefit, index) => (
            <div
              key={benefit.title}
              className="group text-center p-8 bg-white rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-500 transform hover:scale-105"
              style={{ animationDelay: `${index * 150}ms` }}
            >
              <div className="w-20 h-20 bg-gradient-to-br from-purple-500 to-blue-600 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                <benefit.icon className="w-10 h-10 text-white" />
              </div>

              <h3 className="text-xl font-bold text-gray-900 mb-4 group-hover:text-purple-600 transition-colors duration-300">
                {benefit.title}
              </h3>

              <p className="text-gray-600 leading-relaxed">{benefit.description}</p>
            </div>
          ))}
        </div>
      </div>
    </section>
  )
}
