"use client"

import { Button } from "@/components/ui/button"
import { Car, Heart, Home, Ship, Briefcase, Users, Shield, Sparkles, Zap } from "lucide-react"
import { useEffect, useState } from "react"
import Card3D from "./3d-card"

const services = [
  {
    icon: Car,
    title: "Smart Motor Insurance",
    description:
      "AI-powered vehicle protection with instant quotes, telematics discounts, and 24/7 roadside assistance.",
    gradient: "from-blue-500 to-cyan-500",
    bg: "from-blue-50 to-cyan-50",
    image: "https://images.unsplash.com/photo-1449824913935-59a10b8d2000?w=500&h=400&fit=crop&crop=center",
  },
  {
    icon: Heart,
    title: "Digital Health & Life",
    description: "Comprehensive health coverage with telemedicine, wellness programs, and instant claim approvals.",
    gradient: "from-red-500 to-pink-500",
    bg: "from-red-50 to-pink-50",
    image: "https://images.unsplash.com/photo-1559757148-5c350d0d3c56?w=500&h=400&fit=crop&crop=center",
  },
  {
    icon: Home,
    title: "Property Protection Plus",
    description: "Smart home insurance with IoT monitoring, instant damage assessment, and rapid claim processing.",
    gradient: "from-orange-500 to-yellow-500",
    bg: "from-orange-50 to-yellow-50",
    image: "https://images.unsplash.com/photo-1560518883-ce09059eeffa?w=500&h=400&fit=crop&crop=center",
  },
  {
    icon: Ship,
    title: "Marine & Aviation Pro",
    description: "Advanced coverage for maritime and aviation risks with real-time tracking and global protection.",
    gradient: "from-cyan-500 to-teal-500",
    bg: "from-cyan-50 to-teal-50",
    image: "https://images.unsplash.com/photo-1436491865332-7a61a109cc05?w=500&h=400&fit=crop&crop=center",
  },
  {
    icon: Briefcase,
    title: "Professional Shield",
    description: "Comprehensive liability protection for professionals with cyber security and reputation management.",
    gradient: "from-purple-500 to-indigo-500",
    bg: "from-purple-50 to-indigo-50",
    image: "https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=500&h=400&fit=crop&crop=center",
  },
  {
    icon: Users,
    title: "Employee Benefits 360",
    description:
      "Complete employee benefit packages with wellness tracking, mental health support, and family coverage.",
    gradient: "from-green-500 to-emerald-500",
    bg: "from-green-50 to-emerald-50",
    image: "https://images.unsplash.com/photo-1600880292203-757bb62b4baf?w=500&h=400&fit=crop&crop=center",
  },
]

export function ServicesSection() {
  const [isVisible, setIsVisible] = useState(false)

  useEffect(() => {
    const observer = new IntersectionObserver(
      ([entry]) => {
        if (entry.isIntersecting) {
          setIsVisible(true)
        }
      },
      { threshold: 0.1 },
    )

    const element = document.getElementById("services")
    if (element) observer.observe(element)

    return () => observer.disconnect()
  }, [])

  return (
    <section
      id="services"
      className="py-20 bg-gradient-to-br from-slate-50 via-purple-50/20 to-blue-50/20 relative overflow-hidden"
    >
      {/* Background Elements */}
      <div className="absolute inset-0 overflow-hidden">
        <div className="absolute top-40 left-20 w-72 h-72 bg-gradient-to-r from-purple-300/20 to-blue-300/20 rounded-full blur-3xl animate-blob"></div>
        <div className="absolute bottom-40 right-20 w-64 h-64 bg-gradient-to-r from-cyan-300/20 to-teal-300/20 rounded-full blur-3xl animate-blob animation-delay-2000"></div>
      </div>

      <div className="container mx-auto px-4 relative z-10">
        <div
          className={`text-center mb-16 transition-all duration-1000 ${isVisible ? "opacity-100 translate-y-0" : "opacity-0 translate-y-10"}`}
        >
          <div className="inline-flex items-center px-6 py-3 bg-gradient-to-r from-purple-100 to-blue-100 text-purple-800 rounded-full text-sm font-medium border border-purple-200/50 mb-6">
            <Sparkles className="h-4 w-4 mr-2 animate-pulse" />
            Our Premium Services
          </div>

          <h2 className="text-4xl lg:text-5xl font-bold mb-6">
            <span className="bg-gradient-to-r from-purple-600 to-blue-600 bg-clip-text text-transparent">
              Next-Generation
            </span>
            <br />
            <span className="text-slate-900">Insurance Solutions</span>
          </h2>

          <p className="text-xl text-slate-600 max-w-3xl mx-auto leading-relaxed">
            Experience the future of insurance with our AI-powered, customer-centric solutions designed for the modern
            Nigerian lifestyle.
          </p>
        </div>

        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8 mb-12 justify-items-center">
          {services.map((service, index) => (
            <Card3D
              key={index}
              title={service.title}
              content={service.description}
              backgroundImage={service.image}
            />
          ))}
        </div>

        {/* Premium Service Highlight */}
        <div
          className={`text-center transition-all duration-1000 delay-600 ${isVisible ? "opacity-100 translate-y-0" : "opacity-0 translate-y-10"}`}
        >
          <div className="max-w-4xl mx-auto p-8 bg-gradient-to-r from-purple-600 via-blue-600 to-cyan-600 text-white border-0 shadow-2xl overflow-hidden relative group rounded-2xl">
            <div className="absolute inset-0 bg-gradient-to-r from-white/10 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
            <div className="p-0 relative z-10">
              <div className="flex items-center justify-center mb-6">
                <div className="p-4 bg-white/20 backdrop-blur-sm rounded-2xl">
                  <Shield className="h-12 w-12 text-white" />
                </div>
              </div>
              <h3 className="text-3xl font-bold mb-4">AI-Powered Risk Advisory</h3>
              <p className="text-blue-100 mb-8 text-lg max-w-2xl mx-auto leading-relaxed">
                Leverage artificial intelligence and machine learning to identify, assess, and mitigate risks before
                they become problems. Get personalized recommendations tailored to your unique risk profile.
              </p>
              <div className="flex flex-col sm:flex-row gap-4 justify-center">
                <Button
                  variant="secondary"
                  className="bg-white text-purple-600 hover:bg-slate-100 px-8 py-3 rounded-full font-semibold group transition-all duration-300"
                >
                  <Zap className="mr-2 h-5 w-5 group-hover:animate-pulse" />
                  Get AI Assessment
                </Button>
                <Button
                  variant="outline"
                  className="border-2 border-white/50 text-white hover:bg-white/10 px-8 py-3 rounded-full font-semibold backdrop-blur-sm transition-all duration-300 bg-transparent"
                >
                  Learn More
                </Button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}
