"use client"

import { FileText, Scale, Shield, CreditCard, AlertTriangle, Gavel, Phone, Mail, Calendar } from "lucide-react"

export default function TermsConditionsContent() {
  const lastUpdated = "January 15, 2025"

  const sections = [
    {
      id: "acceptance",
      title: "Acceptance of Terms",
      icon: FileText,
      content: [
        {
          subtitle: "Agreement to Terms",
          text: "By accessing and using the services of Bishop & Knight Insurance Brokers Limited, you acknowledge that you have read, understood, and agree to be bound by these Terms and Conditions. If you do not agree to these terms, you must not use our services.",
        },
        {
          subtitle: "Capacity to Contract",
          text: "You represent that you are at least 18 years of age and have the legal capacity to enter into these Terms and Conditions. If you are acting on behalf of an organization, you represent that you have the authority to bind that organization to these terms.",
        },
        {
          subtitle: "Modifications",
          text: "We reserve the right to modify these Terms and Conditions at any time. Changes will be effective immediately upon posting on our website. Your continued use of our services after any changes constitutes acceptance of the new terms.",
        },
      ],
    },
    {
      id: "services",
      title: "Services Provided",
      icon: Shield,
      content: [
        {
          subtitle: "Insurance Brokerage Services",
          text: "Bishop & Knight Insurance Brokers Limited provides insurance brokerage services, including but not limited to policy placement, risk assessment, claims assistance, and insurance advisory services. We act as intermediaries between clients and insurance companies.",
        },
        {
          subtitle: "Professional Standards",
          text: "Our services are provided in accordance with professional standards and regulatory requirements applicable to insurance brokers in Nigeria. We maintain professional indemnity insurance and comply with all relevant regulations.",
        },
        {
          subtitle: "Service Limitations",
          text: "While we strive to provide comprehensive insurance solutions, we cannot guarantee that insurance coverage will be available for all risks or that claims will be accepted by insurers. Final decisions on coverage and claims rest with the insurance companies.",
        },
        {
          subtitle: "Third-Party Services",
          text: "We may engage third-party service providers to assist in delivering our services. We remain responsible for the overall service delivery but are not liable for the independent actions of third parties beyond our reasonable control.",
        },
      ],
    },
    {
      id: "user-responsibilities",
      title: "User Responsibilities",
      icon: Scale,
      content: [
        {
          subtitle: "Accurate Information",
          text: "You must provide accurate, complete, and current information when applying for insurance or using our services. Any misrepresentation or omission of material facts may void your insurance coverage and terminate our services.",
        },
        {
          subtitle: "Compliance with Laws",
          text: "You agree to comply with all applicable laws and regulations in connection with your use of our services. This includes but is not limited to anti-money laundering laws, tax obligations, and insurance regulations.",
        },
        {
          subtitle: "Premium Payments",
          text: "You are responsible for paying all premiums and fees when due. Failure to pay premiums may result in cancellation of your insurance coverage. We are not responsible for lapses in coverage due to non-payment.",
        },
        {
          subtitle: "Notification Obligations",
          text: "You must promptly notify us of any changes in circumstances that may affect your insurance coverage, including changes in risk exposure, claims, or other material changes.",
        },
      ],
    },
    {
      id: "payment-terms",
      title: "Payment Terms",
      icon: CreditCard,
      content: [
        {
          subtitle: "Fees and Commissions",
          text: "Our compensation may include commissions from insurance companies and fees charged directly to clients. All fees will be disclosed to you before services are provided. Payment terms will be specified in your service agreement.",
        },
        {
          subtitle: "Payment Methods",
          text: "We accept various payment methods including bank transfers, credit cards, and other electronic payment methods. Processing fees may apply to certain payment methods and will be disclosed at the time of payment.",
        },
        {
          subtitle: "Late Payments",
          text: "Late payment charges may apply to overdue amounts. We reserve the right to suspend services for accounts with outstanding payments beyond agreed terms.",
        },
        {
          subtitle: "Refunds",
          text: "Refunds, if applicable, will be processed according to the terms of your specific service agreement and applicable insurance policy terms. Processing time for refunds may vary depending on the payment method and circumstances.",
        },
      ],
    },
    {
      id: "limitation-liability",
      title: "Limitation of Liability",
      icon: AlertTriangle,
      content: [
        {
          subtitle: "Professional Services",
          text: "Our liability is limited to the scope of professional services provided as insurance brokers. We are not liable for decisions made by insurance companies regarding coverage, claims, or policy terms.",
        },
        {
          subtitle: "Maximum Liability",
          text: "Our total liability to you for any claims arising from our services shall not exceed the total fees paid by you to us in the 12 months preceding the claim, or the amount covered by our professional indemnity insurance, whichever is lower.",
        },
        {
          subtitle: "Excluded Damages",
          text: "We shall not be liable for any indirect, consequential, special, or punitive damages, including but not limited to loss of profits, business interruption, or loss of data, even if we have been advised of the possibility of such damages.",
        },
        {
          subtitle: "Force Majeure",
          text: "We are not liable for any failure or delay in performance due to circumstances beyond our reasonable control, including but not limited to acts of God, government actions, war, terrorism, or natural disasters.",
        },
      ],
    },
    {
      id: "intellectual-property",
      title: "Intellectual Property",
      icon: Shield,
      content: [
        {
          subtitle: "Ownership",
          text: "All content on our website and in our materials, including text, graphics, logos, images, and software, is the property of Bishop & Knight Insurance Brokers Limited or our licensors and is protected by copyright and other intellectual property laws.",
        },
        {
          subtitle: "Limited License",
          text: "We grant you a limited, non-exclusive, non-transferable license to access and use our website and services for their intended purpose. You may not reproduce, distribute, or create derivative works without our written permission.",
        },
        {
          subtitle: "Trademarks",
          text: "Our company name, logo, and other trademarks are the property of Bishop & Knight Insurance Brokers Limited. You may not use our trademarks without our prior written consent.",
        },
        {
          subtitle: "User Content",
          text: "Any information or content you provide to us may be used by us for the purpose of providing our services and improving our operations, subject to our Privacy Policy.",
        },
      ],
    },
    {
      id: "termination",
      title: "Termination",
      icon: Gavel,
      content: [
        {
          subtitle: "Termination by Either Party",
          text: "Either party may terminate the service relationship with reasonable notice, subject to the terms of any specific service agreements. Termination does not affect obligations that have already accrued.",
        },
        {
          subtitle: "Immediate Termination",
          text: "We may terminate services immediately if you breach these Terms and Conditions, provide false information, or engage in fraudulent or illegal activities.",
        },
        {
          subtitle: "Effect of Termination",
          text: "Upon termination, your right to use our services ceases immediately. We will assist with the orderly transition of your insurance arrangements, subject to applicable regulations and agreements with insurance companies.",
        },
        {
          subtitle: "Survival",
          text: "Provisions relating to limitation of liability, intellectual property, confidentiality, and dispute resolution shall survive termination of these Terms and Conditions.",
        },
      ],
    },
  ]

  return (
    <div className="py-20">
      <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        {/* Header */}
        <div className="text-center mb-16">
          <div className="inline-flex items-center gap-2 bg-blue-100 rounded-full px-4 py-2 mb-6">
            <Scale className="w-5 h-5 text-blue-600" />
            <span className="text-blue-800 font-medium">Legal Terms</span>
          </div>

          <h1 className="text-4xl md:text-5xl font-bold mb-6">
            <span className="bg-gradient-to-r from-purple-600 to-blue-600 bg-clip-text text-transparent">
              Terms & Conditions
            </span>
          </h1>

          <p className="text-xl text-gray-600 max-w-3xl mx-auto mb-8">
            These terms and conditions govern your use of Bishop & Knight Insurance Brokers Limited services and
            website.
          </p>

          <div className="bg-gradient-to-r from-purple-50 to-blue-50 p-6 rounded-2xl border border-purple-200">
            <div className="flex items-center justify-center gap-2 text-purple-800">
              <Calendar className="w-5 h-5" />
              <span className="font-medium">Last Updated: {lastUpdated}</span>
            </div>
          </div>
        </div>

        {/* Introduction */}
        <div className="bg-white rounded-3xl shadow-lg p-8 mb-12">
          <h2 className="text-2xl font-bold text-gray-900 mb-6">Introduction</h2>
          <div className="prose prose-lg text-gray-600 space-y-4">
            <p>
              Welcome to Bishop & Knight Insurance Brokers Limited. These Terms and Conditions ("Terms") govern your use
              of our website, services, and any related applications or platforms (collectively, the "Services").
            </p>
            <p>
              Bishop & Knight Insurance Brokers Limited is a licensed insurance brokerage firm operating under Nigerian
              law. We provide professional insurance brokerage services to individuals, businesses, and organizations.
            </p>
            <p>
              Please read these Terms carefully before using our Services. By accessing or using our Services, you agree
              to be bound by these Terms and our Privacy Policy.
            </p>
          </div>
        </div>

        {/* Main Sections */}
        <div className="space-y-8">
          {sections.map((section, index) => {
            const IconComponent = section.icon
            return (
              <div key={section.id} className="bg-white rounded-3xl shadow-lg overflow-hidden">
                <div className="bg-gradient-to-r from-blue-600 to-purple-600 p-6">
                  <div className="flex items-center gap-3">
                    <div className="bg-white/20 rounded-full p-3">
                      <IconComponent className="w-6 h-6 text-white" />
                    </div>
                    <h2 className="text-2xl font-bold text-white">{section.title}</h2>
                  </div>
                </div>

                <div className="p-8">
                  <div className="space-y-6">
                    {section.content.map((item, itemIndex) => (
                      <div key={itemIndex}>
                        <h3 className="text-lg font-semibold text-gray-900 mb-3">{item.subtitle}</h3>
                        <p className="text-gray-600 leading-relaxed">{item.text}</p>
                      </div>
                    ))}
                  </div>
                </div>
              </div>
            )
          })}
        </div>

        {/* Governing Law */}
        <div className="bg-white rounded-3xl shadow-lg p-8 mt-12">
          <h2 className="text-2xl font-bold text-gray-900 mb-6 flex items-center">
            <Gavel className="w-6 h-6 text-blue-600 mr-3" />
            Governing Law and Jurisdiction
          </h2>
          <div className="prose prose-lg text-gray-600 space-y-4">
            <p>
              These Terms and Conditions are governed by and construed in accordance with the laws of the Federal
              Republic of Nigeria. Any disputes arising from or relating to these Terms or our Services shall be subject
              to the exclusive jurisdiction of the Nigerian courts.
            </p>
            <p>
              We are regulated by the National Insurance Commission (NAICOM) and comply with all applicable Nigerian
              insurance laws and regulations.
            </p>
          </div>
        </div>

        {/* Dispute Resolution */}
        <div className="bg-white rounded-3xl shadow-lg p-8 mt-8">
          <h2 className="text-2xl font-bold text-gray-900 mb-6 flex items-center">
            <Scale className="w-6 h-6 text-blue-600 mr-3" />
            Dispute Resolution
          </h2>
          <div className="prose prose-lg text-gray-600 space-y-4">
            <p>
              We are committed to resolving any disputes amicably. If you have a complaint or dispute, please contact us
              first to allow us the opportunity to resolve the matter directly.
            </p>
            <p>
              If we cannot resolve a dispute through direct negotiation, the matter may be referred to mediation or
              arbitration as agreed between the parties, or to the appropriate regulatory body or court as required by
              law.
            </p>
            <p>
              For insurance-related complaints, you may also contact the National Insurance Commission (NAICOM) or other
              relevant regulatory authorities.
            </p>
          </div>
        </div>

        {/* Contact Information */}
        <div className="bg-gradient-to-r from-blue-600 to-purple-600 rounded-3xl shadow-lg p-8 mt-12 text-white">
          <h2 className="text-2xl font-bold mb-6 flex items-center">
            <Phone className="w-6 h-6 mr-3" />
            Contact Us About These Terms
          </h2>
          <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
              <h3 className="text-lg font-semibold mb-3">Legal Department</h3>
              <div className="space-y-2">
                <div className="flex items-center gap-2">
                  <Mail className="w-4 h-4" />
                  <a href="mailto:legal@bishopknight.com" className="hover:underline">
                    legal@bishopknight.com
                  </a>
                </div>
                <div className="flex items-center gap-2">
                  <Phone className="w-4 h-4" />
                  <a href="tel:+2341234567890" className="hover:underline">
                    +234 123 456 7890
                  </a>
                </div>
              </div>
            </div>
            <div>
              <h3 className="text-lg font-semibold mb-3">Registered Office</h3>
              <p className="text-blue-100">
                Bishop & Knight Insurance Brokers Limited
                <br />
                123 Victoria Island
                <br />
                Lagos, Nigeria
              </p>
            </div>
          </div>
          <div className="mt-6 p-4 bg-white/10 rounded-xl">
            <p className="text-sm text-blue-100">
              If you have any questions about these Terms and Conditions, please contact us using the information above.
              We will respond to your inquiry within 5 business days.
            </p>
          </div>
        </div>

        {/* Severability */}
        <div className="bg-white rounded-3xl shadow-lg p-8 mt-12">
          <h2 className="text-2xl font-bold text-gray-900 mb-6">Severability and Entire Agreement</h2>
          <div className="prose prose-lg text-gray-600 space-y-4">
            <p>
              If any provision of these Terms and Conditions is found to be invalid, illegal, or unenforceable, the
              remaining provisions shall continue in full force and effect. The invalid provision shall be replaced with
              a valid provision that most closely reflects the intent of the original provision.
            </p>
            <p>
              These Terms and Conditions, together with our Privacy Policy and any specific service agreements,
              constitute the entire agreement between you and Bishop & Knight Insurance Brokers Limited regarding the
              use of our Services.
            </p>
            <p>
              No waiver of any provision of these Terms shall be deemed a waiver of any other provision or of the same
              provision on a future occasion.
            </p>
          </div>
        </div>
      </div>
    </div>
  )
}
