"use client"

import type { ReactNode } from "react"

interface GlowingCardProps {
  children: ReactNode
  className?: string
}

export function GlowingCard({ children, className = "" }: GlowingCardProps) {
  return (
    <div className={`glowing-card ${className}`}>
      <span className="glowing-card-inner" />
      <div className="glowing-card-content">{children}</div>
    </div>
  )
}
