import { NextResponse } from "next/server"
import type { NextRequest } from "next/request"

export function middleware(request: NextRequest) {
  const { pathname } = request.nextUrl
  const isAdminRoot = pathname === "/admin" || pathname === "/admin/"

  if (pathname.startsWith("/admin") && !isAdminRoot) {
    const adminLoggedIn = request.cookies.get("adminLoggedIn")?.value

    if (!adminLoggedIn) {
      const url = request.nextUrl.clone()
      // Use trailing slash to avoid redirect loops when trailingSlash is true
      url.pathname = "/admin/"
      return NextResponse.redirect(url)
    }
  }

  return NextResponse.next()
}

export const config = {
  matcher: "/admin/:path*",
}
