import type { Metadata } from "next"
import CheckoutFlow from "@/components/checkout-flow"
import Header from "@/components/header"
import Footer from "@/components/footer"

export const metadata: Metadata = {
  title: "Checkout | Bishop & Knight Insurance Brokers",
  description: "Complete your insurance purchase with our secure checkout process.",
}

export default function CheckoutPage() {
  return (
    <div className="min-h-screen bg-gradient-to-br from-slate-50 to-blue-50">
      <Header />
      <main className="py-12">
        <CheckoutFlow />
      </main>
      <Footer />
    </div>
  )
}
