import type { Metadata } from "next"
import CookiePolicyContent from "@/components/cookie-policy-content"
import Header from "@/components/header"
import Footer from "@/components/footer"

export const metadata: Metadata = {
  title: "Cookie Policy | Bishop & Knight Insurance Brokers",
  description:
    "Learn about how Bishop & Knight Insurance Brokers uses cookies and similar technologies to improve your browsing experience.",
}

export default function CookiePolicyPage() {
  return (
    <div className="min-h-screen bg-gradient-to-br from-slate-50 to-blue-50">
      <Header />
      <main>
        <CookiePolicyContent />
      </main>
      <Footer />
    </div>
  )
}
