import type React from "react"
import type { Metadata } from "next"
import { Inter, Space_Grotesk } from "next/font/google"
import "./globals.css"
import { ShoppingCartProvider } from "@/components/shopping-cart-provider"

const inter = Inter({
  subsets: ["latin"],
  display: "swap",
  variable: "--font-inter",
})

const spaceGrotesk = Space_Grotesk({
  subsets: ["latin"],
  display: "swap",
  variable: "--font-space-grotesk",
})

export const metadata: Metadata = {
  title: "Bishop & Knight Insurance Brokers Limited - Nigeria's Premier Insurance Partners",
  description:
    "Experience the future of insurance with Bishop & Knight. Cutting-edge solutions, personalized service, and unmatched protection for modern Nigerians. Get instant quotes today!",
  keywords:
    "insurance Nigeria, motor insurance, health insurance, property insurance, marine insurance, professional indemnity, Bishop Knight, NAICOM approved, instant quotes",
    generator: 'v0.app'
}

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode
}>) {
  return (
    <html lang="en" className={`${inter.variable} ${spaceGrotesk.variable} antialiased`}>
      <body className="font-sans">
        <ShoppingCartProvider>{children}</ShoppingCartProvider>
      </body>
    </html>
  )
}
