"use client"

import type React from "react"

interface Card3DProps {
  title: string
  content: string
  buttonText?: string
  dateMonth?: string
  dateDay?: string
  onClick?: () => void
  backgroundImage?: string
}

const Card3D: React.FC<Card3DProps> = ({
  title,
  content,
  buttonText = "Learn More",
  dateMonth = "NEW",
  dateDay = "24",
  onClick,
  backgroundImage,
}) => {
  return (
    <div className="w-full max-w-sm p-5" style={{ perspective: "1000px" }}>
      <div
        className="relative w-full pt-12 border-4 border-gray-800 transition-all duration-500 ease-in-out hover:rotate-y-30 shadow-2xl group"
        style={{
          transformStyle: "preserve-3d",
          background: `linear-gradient(135deg, transparent 18.75%, #f3f3f3 0 31.25%, transparent 0),
                      repeating-linear-gradient(45deg, #f3f3f3 -6.25% 6.25%, #141414 0 18.75%)`,
          backgroundSize: "60px 60px",
          backgroundPosition: "0 0, 0 0",
          backgroundColor: "#141414",
        }}
        onMouseEnter={(e) => {
          e.currentTarget.style.backgroundPosition = "-100px 100px, -100px 100px"
          e.currentTarget.style.transform = "rotate3d(0.5, 1, 0, 30deg)"
        }}
        onMouseLeave={(e) => {
          e.currentTarget.style.backgroundPosition = "0 0, 0 0"
          e.currentTarget.style.transform = "rotate3d(0, 0, 0, 0deg)"
        }}
      >
        {/* Content Box */}
        <div
          className="p-6 pt-16 transition-all duration-500 ease-in-out"
          style={{
            transformStyle: "preserve-3d",
            backgroundImage: backgroundImage 
              ? `linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.7)), url(${backgroundImage})`
              : 'none',
            backgroundColor: backgroundImage ? 'transparent' : '#a3e635',
            backgroundSize: 'cover',
            backgroundPosition: 'center',
          }}
        >
          <h3
            className="inline-block text-white text-2xl font-black transition-all duration-500 ease-in-out hover:translate-z-60"
            style={{ transform: "translate3d(0px, 0px, 50px)" }}
          >
            {title}
          </h3>

          <p
            className="mt-3 text-xs font-bold text-white transition-all duration-500 ease-in-out hover:translate-z-60"
            style={{ transform: "translate3d(0px, 0px, 30px)" }}
          >
            {content}
          </p>

          <button
            onClick={onClick}
            className="cursor-pointer mt-4 inline-block font-black text-xs uppercase text-white bg-gray-800 bg-opacity-80 px-3 py-2 transition-all duration-500 ease-in-out hover:translate-z-60 hover:bg-opacity-100"
            style={{ transform: "translate3d(0px, 0px, 20px)" }}
          >
            {buttonText}
          </button>
        </div>

        {/* Date Box */}
        <div
          className="absolute top-8 right-8 h-16 w-16 bg-gray-800 border border-white p-3 shadow-lg"
          style={{ transform: "translate3d(0px, 0px, 80px)" }}
        >
          <span className="block text-center text-white text-xs font-bold">{dateMonth}</span>
          <span className="block text-center text-xl font-black text-white">{dateDay}</span>
        </div>
      </div>
    </div>
  )
}

export default Card3D
