"use client"

import { Card, CardContent } from "@/components/ui/card"
import { Award, TrendingUp, Users, Shield, Star, Zap } from "lucide-react"
import { useEffect, useState } from "react"

const achievements = [
  {
    icon: Award,
    title: "Industry Excellence Award",
    year: "2024",
    description: "Recognized as Nigeria's Most Innovative Insurance Technology Company",
    gradient: "from-yellow-500 to-orange-500",
  },
  {
    icon: TrendingUp,
    title: "Digital Transformation Leader",
    year: "2023",
    description: "Leading the digital revolution in Nigeria's insurance sector",
    gradient: "from-blue-500 to-cyan-500",
  },
  {
    icon: Users,
    title: "Customer Service Excellence",
    year: "2023",
    description: "99.8% customer satisfaction rating across all service channels",
    gradient: "from-green-500 to-teal-500",
  },
  {
    icon: Shield,
    title: "NAICOM Certification",
    year: "2020",
    description: "Fully licensed and regulated by the National Insurance Commission",
    gradient: "from-purple-500 to-indigo-500",
  },
  {
    icon: Star,
    title: "Fintech Innovation Award",
    year: "2022",
    description: "Pioneering AI-powered risk assessment and claims processing",
    gradient: "from-pink-500 to-red-500",
  },
  {
    icon: Zap,
    title: "Technology Excellence",
    year: "2024",
    description: "Fastest claims processing in Nigeria - 24-hour settlement guarantee",
    gradient: "from-cyan-500 to-blue-500",
  },
]

const stats = [
  { number: "5,000+", label: "Happy Clients", gradient: "from-purple-500 to-blue-500" },
  { number: "₦2B+", label: "Claims Processed", gradient: "from-green-500 to-teal-500" },
  { number: "99.8%", label: "Satisfaction Rate", gradient: "from-orange-500 to-red-500" },
  { number: "24hrs", label: "Avg Settlement", gradient: "from-cyan-500 to-blue-500" },
]

export function AchievementsSection() {
  const [isVisible, setIsVisible] = useState(false)

  useEffect(() => {
    const observer = new IntersectionObserver(
      ([entry]) => {
        if (entry.isIntersecting) {
          setIsVisible(true)
        }
      },
      { threshold: 0.1 },
    )

    const element = document.getElementById("achievements")
    if (element) observer.observe(element)

    return () => observer.disconnect()
  }, [])

  return (
    <section
      id="achievements"
      className="py-20 bg-gradient-to-br from-slate-50 via-purple-50/30 to-blue-50/30 relative overflow-hidden"
    >
      {/* Background Elements */}
      <div className="absolute inset-0 overflow-hidden">
        <div className="absolute top-20 left-20 w-80 h-80 bg-gradient-to-r from-purple-200/30 to-blue-200/30 rounded-full blur-3xl animate-pulse"></div>
        <div className="absolute bottom-20 right-20 w-72 h-72 bg-gradient-to-r from-cyan-200/30 to-teal-200/30 rounded-full blur-3xl animate-pulse animation-delay-2000"></div>
      </div>

      <div className="container mx-auto px-4 relative z-10">
        <div
          className={`text-center mb-16 transition-all duration-1000 ${isVisible ? "opacity-100 translate-y-0" : "opacity-0 translate-y-10"}`}
        >
          <div className="inline-flex items-center px-6 py-3 bg-gradient-to-r from-purple-100 to-blue-100 text-purple-800 rounded-full text-sm font-medium border border-purple-200/50 mb-6">
            <Award className="h-4 w-4 mr-2 animate-pulse" />
            Our Achievements
          </div>

          <h2 className="text-4xl lg:text-5xl font-bold mb-6">
            <span className="bg-gradient-to-r from-purple-600 to-blue-600 bg-clip-text text-transparent">
              Recognition &
            </span>
            <br />
            <span className="text-slate-900">Industry Leadership</span>
          </h2>

          <p className="text-xl text-slate-600 max-w-3xl mx-auto leading-relaxed">
            Our commitment to excellence and innovation has earned us recognition as a leader in Nigeria's insurance
            technology landscape.
          </p>
        </div>

        {/* Stats Section */}
        <div
          className={`grid grid-cols-2 lg:grid-cols-4 gap-6 mb-16 transition-all duration-1000 ${isVisible ? "opacity-100 translate-y-0" : "opacity-0 translate-y-10"}`}
        >
          {stats.map((stat, index) => (
            <Card
              key={index}
              className="group hover:shadow-2xl transition-all duration-500 border-0 shadow-lg hover:-translate-y-3 bg-white/80 backdrop-blur-sm overflow-hidden"
              style={{ transitionDelay: `${index * 100}ms` }}
            >
              <CardContent className="p-6 text-center relative">
                <div
                  className={`absolute inset-0 bg-gradient-to-r ${stat.gradient} opacity-0 group-hover:opacity-5 transition-opacity duration-300`}
                ></div>
                <div className="relative z-10">
                  <div
                    className={`text-3xl font-bold bg-gradient-to-r ${stat.gradient} bg-clip-text text-transparent mb-2 group-hover:scale-110 transition-transform duration-300`}
                  >
                    {stat.number}
                  </div>
                  <div className="text-slate-600 text-sm font-medium">{stat.label}</div>
                </div>
              </CardContent>
            </Card>
          ))}
        </div>

        {/* Achievements Grid */}
        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
          {achievements.map((achievement, index) => (
            <Card
              key={index}
              className={`group hover:shadow-2xl transition-all duration-500 border-0 shadow-lg hover:-translate-y-3 bg-white/80 backdrop-blur-sm overflow-hidden ${
                isVisible ? "opacity-100 translate-y-0" : "opacity-0 translate-y-10"
              }`}
              style={{ transitionDelay: `${(index + 4) * 150}ms` }}
            >
              <CardContent className="p-8 relative">
                <div
                  className={`absolute inset-0 bg-gradient-to-r ${achievement.gradient} opacity-0 group-hover:opacity-5 transition-opacity duration-300`}
                ></div>
                <div className="relative z-10">
                  <div className="flex items-center justify-between mb-6">
                    <div
                      className={`p-3 bg-gradient-to-r ${achievement.gradient} rounded-xl group-hover:scale-110 transition-transform duration-300 shadow-lg`}
                    >
                      <achievement.icon className="h-6 w-6 text-white" />
                    </div>
                    <div
                      className={`text-sm font-bold bg-gradient-to-r ${achievement.gradient} bg-clip-text text-transparent`}
                    >
                      {achievement.year}
                    </div>
                  </div>
                  <h3 className="text-xl font-bold text-slate-900 mb-3 group-hover:text-purple-700 transition-colors duration-300">
                    {achievement.title}
                  </h3>
                  <p className="text-slate-600 leading-relaxed text-sm">{achievement.description}</p>
                </div>
              </CardContent>
            </Card>
          ))}
        </div>
      </div>
    </section>
  )
}
