"use client"

import { Card, CardContent } from "@/components/ui/card"
import { Building2, Target, CheckCircle, Users, Shield, Zap } from "lucide-react"
import { useEffect, useState } from "react"

const whoWeAreFeatures = [
  {
    icon: Building2,
    title: "Fully Licensed",
    description: "Dynamic and fully licensed insurance brokerage firm",
  },
  {
    icon: Target,
    title: "Quality Focus",
    description: "Focus on quality service and innovation",
  },
  {
    icon: Users,
    title: "Client-Centric",
    description: "Meeting the evolving needs of our clients",
  },
]

const whatWeDoServices = [
  {
    icon: Shield,
    title: "Competitive Premiums",
    description: "We negotiate with top-rated insurers to secure the best rates for our clients",
  },
  {
    icon: CheckCircle,
    title: "Flexible Terms",
    description: "Customized terms and conditions that work for your specific needs",
  },
  {
    icon: Zap,
    title: "Favorable Discounts",
    description: "Access to exclusive discounts and specialized underwriting services",
  },
]

export function CompanyStorySection() {
  const [isVisible, setIsVisible] = useState(false)

  useEffect(() => {
    const observer = new IntersectionObserver(
      ([entry]) => {
        if (entry.isIntersecting) {
          setIsVisible(true)
        }
      },
      { threshold: 0.1 },
    )

    const element = document.getElementById("company-story")
    if (element) observer.observe(element)

    return () => observer.disconnect()
  }, [])

  return (
    <section
      id="company-story"
      className="py-20 bg-gradient-to-br from-slate-50 via-white to-purple-50/30 relative overflow-hidden"
    >
      <div className="absolute inset-0 overflow-hidden">
        <div className="absolute top-20 right-10 w-96 h-96 bg-gradient-to-r from-purple-200/30 to-blue-200/30 rounded-full blur-3xl animate-blob"></div>
        <div className="absolute bottom-20 left-10 w-80 h-80 bg-gradient-to-r from-cyan-200/30 to-teal-200/30 rounded-full blur-3xl animate-blob animation-delay-2000"></div>
        <div className="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-64 h-64 bg-gradient-to-r from-pink-200/20 to-orange-200/20 rounded-full blur-3xl animate-blob animation-delay-4000"></div>
      </div>

      <div className="container mx-auto px-4 relative z-10">
        <div className="grid lg:grid-cols-2 gap-16 items-start">
          {/* Who We Are Section */}
          <div
            className={`transition-all duration-1000 ${isVisible ? "opacity-100 translate-x-0" : "opacity-0 -translate-x-10"}`}
          >
            <div className="mb-8">
              <div className="inline-flex items-center px-6 py-3 bg-gradient-to-r from-purple-100 to-blue-100 text-purple-800 rounded-full text-sm font-medium border border-purple-200/50 mb-6">
                <Building2 className="h-4 w-4 mr-2" />
                Who We Are
              </div>

              <h2 className="text-4xl lg:text-5xl font-bold mb-6">
                <span className="bg-gradient-to-r from-purple-600 to-blue-600 bg-clip-text text-transparent">
                  Dynamic Insurance
                </span>
                <br />
                <span className="text-slate-900">Brokerage Firm</span>
              </h2>

              <p className="text-lg text-slate-600 leading-relaxed mb-8">
                We are a dynamic and fully licensed insurance brokerage firm offering a broad range of insurance
                products designed to meet the evolving needs of our clients. With a focus on quality service and
                innovation, we aim to redefine the insurance experience through professionalism, transparency, and
                reliability.
              </p>
            </div>

            <div className="space-y-4">
              {whoWeAreFeatures.map((feature, index) => (
                <Card
                  key={index}
                  className={`bg-white/80 backdrop-blur-sm border-0 shadow-lg hover:shadow-xl transition-all duration-300 group hover:-translate-y-1 ${
                    isVisible ? "opacity-100 translate-y-0" : "opacity-0 translate-y-5"
                  }`}
                  style={{ transitionDelay: `${index * 150}ms` }}
                >
                  <CardContent className="p-6">
                    <div className="flex items-center">
                      <div className="p-3 bg-gradient-to-r from-purple-500 to-blue-500 rounded-xl mr-4 group-hover:scale-110 transition-transform duration-300">
                        <feature.icon className="h-5 w-5 text-white" />
                      </div>
                      <div>
                        <h3 className="font-semibold text-slate-900 mb-1">{feature.title}</h3>
                        <p className="text-slate-600 text-sm">{feature.description}</p>
                      </div>
                    </div>
                  </CardContent>
                </Card>
              ))}
            </div>
          </div>

          {/* What We Do Section */}
          <div
            className={`transition-all duration-1000 ${isVisible ? "opacity-100 translate-x-0" : "opacity-0 translate-x-10"}`}
            style={{ transitionDelay: "300ms" }}
          >
            <div className="mb-8">
              <div className="inline-flex items-center px-6 py-3 bg-gradient-to-r from-green-100 to-teal-100 text-green-800 rounded-full text-sm font-medium border border-green-200/50 mb-6">
                <Target className="h-4 w-4 mr-2" />
                What We Do
              </div>

              <h2 className="text-4xl lg:text-5xl font-bold mb-6">
                <span className="bg-gradient-to-r from-green-600 to-teal-600 bg-clip-text text-transparent">
                  Tailored Insurance
                </span>
                <br />
                <span className="text-slate-900">Solutions</span>
              </h2>

              <p className="text-lg text-slate-600 leading-relaxed mb-8">
                At Bishop & Knight, we don't just sell insurance — we build tailored insurance solutions. Acting on your
                behalf, we negotiate with top-rated insurers to provide the best value for individuals, small
                businesses, and large enterprises.
              </p>
            </div>

            <div className="space-y-4">
              {whatWeDoServices.map((service, index) => (
                <Card
                  key={index}
                  className={`bg-white/80 backdrop-blur-sm border-0 shadow-lg hover:shadow-xl transition-all duration-300 group hover:-translate-y-1 ${
                    isVisible ? "opacity-100 translate-y-0" : "opacity-0 translate-y-5"
                  }`}
                  style={{ transitionDelay: `${(index + 3) * 150}ms` }}
                >
                  <CardContent className="p-6">
                    <div className="flex items-start">
                      <div className="p-3 bg-gradient-to-r from-green-500 to-teal-500 rounded-xl mr-4 group-hover:scale-110 transition-transform duration-300 flex-shrink-0">
                        <service.icon className="h-5 w-5 text-white" />
                      </div>
                      <div>
                        <h3 className="font-semibold text-slate-900 mb-2">{service.title}</h3>
                        <p className="text-slate-600 text-sm leading-relaxed">{service.description}</p>
                      </div>
                    </div>
                  </CardContent>
                </Card>
              ))}
            </div>

            <div className="mt-8 p-6 bg-gradient-to-r from-green-50 to-teal-50 rounded-2xl border border-green-100">
              <p className="text-slate-700 text-center font-medium">
                <span className="text-green-600">
                  Whether you're an individual, small business, or large enterprise,
                </span>
                <br />
                our goal is to help you secure the right coverage at the best possible value.
              </p>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}
