import { MapPin, Phone, Mail, Clock } from "lucide-react"

const contactInfo = [
  {
    icon: MapPin,
    title: "Office Address",
    details: ["123 Victoria Island", "Lagos, Nigeria"],
    link: "https://maps.google.com",
  },
  {
    icon: Phone,
    title: "Phone Number",
    details: ["+234 801 234 5678", "+234 809 876 5432"],
    link: "tel:+2348012345678",
  },
  {
    icon: Mail,
    title: "Email Address",
    details: ["info@bishopknight.com", "quotes@bishopknight.com"],
    link: "mailto:info@bishopknight.com",
  },
  {
    icon: Clock,
    title: "Business Hours",
    details: ["Mon - Fri: 8:00am - 5:00pm", "Sat: 9:00am - 2:00pm"],
    link: null,
  },
]

export function ContactInfoSection() {
  return (
    <section className="py-20 bg-white">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-16">
          <h2 className="text-4xl md:text-5xl font-bold bg-gradient-to-r from-purple-600 to-blue-600 bg-clip-text text-transparent mb-6">
            Get In Touch
          </h2>
          <p className="text-xl text-gray-600 max-w-3xl mx-auto">
            Ready to experience insurance built around you? Reach out today and let Bishop & Knight Insurance Brokers
            help you protect what matters most.
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
          {contactInfo.map((info, index) => (
            <div
              key={info.title}
              className="group text-center p-8 bg-gradient-to-br from-white to-gray-50 rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-500 transform hover:scale-105 border border-gray-100"
              style={{ animationDelay: `${index * 150}ms` }}
            >
              <div className="w-20 h-20 bg-gradient-to-br from-purple-500 to-blue-600 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition-transform duration-300">
                <info.icon className="w-10 h-10 text-white" />
              </div>

              <h3 className="text-xl font-bold text-gray-900 mb-4 group-hover:text-purple-600 transition-colors duration-300">
                {info.title}
              </h3>

              <div className="space-y-2">
                {info.details.map((detail, idx) => (
                  <p key={idx} className="text-gray-600">
                    {info.link && idx === 0 ? (
                      <a href={info.link} className="hover:text-purple-600 transition-colors duration-300">
                        {detail}
                      </a>
                    ) : (
                      detail
                    )}
                  </p>
                ))}
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  )
}
