"use client"

import { Card, CardContent } from "@/components/ui/card"
import { Button } from "@/components/ui/button"
import { Linkedin, Mail, Award, Users } from "lucide-react"
import { useEffect, useState } from "react"

const leaders = [
  {
    name: "Alhaji Rasaki Oladejo, FCS",
    position: "Chairman",
    description:
      "Visionary leader with 25+ years transforming Nigeria's financial landscape. Expert in capital markets, economic research, and strategic innovation.",
    image: "/team.png",
    gradient: "from-purple-500 to-blue-500",
    achievements: ["Capital Market Expert", "Economic Research Leader", "Strategic Innovation"],
  },
  {
    name: "Adetutu Ayantayo, FCS",
    position: "Director",
    description:
      "Pioneering stockbroker and asset management professional driving digital transformation in financial services for over three decades.",
    image: "/team.png",
    gradient: "from-green-500 to-teal-500",
    achievements: ["Asset Management Pioneer", "Digital Transformation", "Financial Innovation"],
  },
  {
    name: "Opeyemi Oladejo, CFA, FCS, FCCA, ACII",
    position: "Managing Director/CEO",
    description:
      "Dynamic leader revolutionizing insurance with AI and technology. 15+ years building next-generation financial services across multiple sectors.",
    image: "/team.png",
    gradient: "from-orange-500 to-red-500",
    achievements: ["AI & Technology Leader", "Multi-Sector Expert", "Innovation Driver"],
  },
]

export function LeadershipSection() {
  const [isVisible, setIsVisible] = useState(false)

  useEffect(() => {
    const observer = new IntersectionObserver(
      ([entry]) => {
        if (entry.isIntersecting) {
          setIsVisible(true)
        }
      },
      { threshold: 0.1 },
    )

    const element = document.getElementById("leadership")
    if (element) observer.observe(element)

    return () => observer.disconnect()
  }, [])

  return (
    <section
      id="leadership"
      className="py-20 bg-gradient-to-br from-slate-50 via-purple-50/30 to-blue-50/30 relative overflow-hidden"
    >
      {/* Background Elements */}
      <div className="absolute inset-0 overflow-hidden">
        <div className="absolute top-32 right-20 w-80 h-80 bg-gradient-to-r from-purple-200/30 to-blue-200/30 rounded-full blur-3xl animate-pulse"></div>
        <div className="absolute bottom-32 left-20 w-64 h-64 bg-gradient-to-r from-cyan-200/30 to-teal-200/30 rounded-full blur-3xl animate-pulse animation-delay-2000"></div>
      </div>

      <div className="container mx-auto px-4 relative z-10">
        <div
          className={`text-center mb-16 transition-all duration-1000 ${isVisible ? "opacity-100 translate-y-0" : "opacity-0 translate-y-10"}`}
        >
          <div className="inline-flex items-center px-6 py-3 bg-gradient-to-r from-purple-100 to-blue-100 text-purple-800 rounded-full text-sm font-medium border border-purple-200/50 mb-6">
            <Users className="h-4 w-4 mr-2 animate-pulse" />
            Meet Our Leadership
          </div>

          <h2 className="text-4xl lg:text-5xl font-bold mb-6">
            <span className="bg-gradient-to-r from-purple-600 to-blue-600 bg-clip-text text-transparent">
              Visionary Leaders
            </span>
            <br />
            <span className="text-slate-900">Driving Innovation</span>
          </h2>

          <p className="text-xl text-slate-600 max-w-3xl mx-auto leading-relaxed">
            Meet the exceptional minds behind Bishop & Knight's transformation of Nigeria's insurance landscape.
          </p>
        </div>

        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8 mb-12">
          {leaders.map((leader, index) => (
            <Card
              key={index}
              className={`group hover:shadow-2xl transition-all duration-500 border-0 shadow-lg hover:-translate-y-3 overflow-hidden bg-white/80 backdrop-blur-sm ${
                isVisible ? "opacity-100 translate-y-0" : "opacity-0 translate-y-10"
              }`}
              style={{ transitionDelay: `${index * 200}ms` }}
            >
              <CardContent className="p-0">
                <div className="relative overflow-hidden">
                  <img
                    src={leader.image || "/team.png"}
                    alt={leader.name}
                    className="w-full h-80 object-cover group-hover:scale-110 transition-transform duration-500"
                  />
                  <div
                    className={`absolute inset-0 bg-gradient-to-t ${leader.gradient} opacity-20 group-hover:opacity-30 transition-opacity duration-300`}
                  ></div>

                  {/* Floating Achievement Badge */}
                  <div className="absolute top-4 right-4 bg-white/90 backdrop-blur-sm p-2 rounded-full group-hover:scale-110 transition-transform duration-300">
                    <Award className={`h-5 w-5 bg-gradient-to-r ${leader.gradient} bg-clip-text text-transparent`} />
                  </div>
                </div>

                <div className="p-6">
                  <h3 className="text-xl font-bold text-slate-900 mb-2 group-hover:text-purple-700 transition-colors duration-300">
                    {leader.name}
                  </h3>

                  <div
                    className={`text-transparent bg-gradient-to-r ${leader.gradient} bg-clip-text font-semibold mb-4`}
                  >
                    {leader.position}
                  </div>

                  <p className="text-slate-600 text-sm leading-relaxed mb-4">{leader.description}</p>

                  {/* Achievements */}
                  <div className="space-y-2 mb-6">
                    {leader.achievements.map((achievement, idx) => (
                      <div key={idx} className="flex items-center space-x-2">
                        <div className={`w-2 h-2 bg-gradient-to-r ${leader.gradient} rounded-full`}></div>
                        <span className="text-xs text-slate-500">{achievement}</span>
                      </div>
                    ))}
                  </div>

                  {/* Social Links */}
                  <div className="flex space-x-3">
                    <Button
                      size="sm"
                      variant="outline"
                      className={`border-2 hover:bg-gradient-to-r ${leader.gradient} hover:text-white hover:border-transparent transition-all duration-300 bg-transparent`}
                    >
                      <Linkedin className="h-4 w-4" />
                    </Button>
                    <Button
                      size="sm"
                      variant="outline"
                      className={`border-2 hover:bg-gradient-to-r ${leader.gradient} hover:text-white hover:border-transparent transition-all duration-300 bg-transparent`}
                    >
                      <Mail className="h-4 w-4" />
                    </Button>
                  </div>
                </div>
              </CardContent>
            </Card>
          ))}
        </div>

        {/* Team Stats */}
        <div
          className={`transition-all duration-1000 delay-600 ${isVisible ? "opacity-100 translate-y-0" : "opacity-0 translate-y-10"}`}
        >
          <Card className="bg-gradient-to-r from-purple-600 via-blue-600 to-cyan-600 text-white border-0 shadow-2xl overflow-hidden relative group">
            <div className="absolute inset-0 bg-gradient-to-r from-white/10 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
            <CardContent className="p-8 relative z-10">
              <div className="text-center mb-8">
                <h3 className="text-3xl font-bold mb-4">Our Team Excellence</h3>
                <p className="text-blue-100 text-lg max-w-2xl mx-auto">
                  Combined decades of expertise driving innovation in Nigeria's financial services sector.
                </p>
              </div>

              <div className="grid grid-cols-2 md:grid-cols-4 gap-8">
                {[
                  { number: "75+", label: "Years Combined Experience" },
                  { number: "50+", label: "Industry Awards" },
                  { number: "15+", label: "Professional Certifications" },
                  { number: "100%", label: "Innovation Focused" },
                ].map((stat, index) => (
                  <div key={index} className="text-center group">
                    <div className="text-3xl font-bold mb-2 group-hover:scale-110 transition-transform duration-300">
                      {stat.number}
                    </div>
                    <div className="text-blue-100 text-sm">{stat.label}</div>
                  </div>
                ))}
              </div>
            </CardContent>
          </Card>
        </div>
      </div>
    </section>
  )
}
