import { Target, Eye, Heart, Users } from "lucide-react"

const values = [
  {
    icon: Target,
    title: "Our Mission",
    description:
      "To become the biggest and most efficient provider of Insurance Brokerage/Consultancy services to Nigerian individuals and institutions while maintaining the highest level of trust and returns to our customers, employees and shareholders.",
  },
  {
    icon: Eye,
    title: "Our Vision",
    description: "To be the preferred insurance brokers to our valuable clients both locally and globally.",
  },
  {
    icon: Heart,
    title: "Core Values",
    description: "Integrity, Team work, Professionalism, and Continuous Learning guide everything we do.",
  },
  {
    icon: Users,
    title: "Leadership Philosophy",
    description:
      "We believe in empowering our team, fostering innovation, and building lasting relationships with our clients through transparent and ethical business practices.",
  },
]

export function LeadershipValuesSection() {
  return (
    <section className="py-20 bg-gradient-to-br from-purple-50 to-blue-50">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-16">
          <h2 className="text-4xl md:text-5xl font-bold bg-gradient-to-r from-purple-600 to-blue-600 bg-clip-text text-transparent mb-6">
            Leadership Principles
          </h2>
          <p className="text-xl text-gray-600 max-w-3xl mx-auto">
            Our leadership team is guided by clear principles that drive our success and commitment to excellence
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
          {values.map((value, index) => (
            <div
              key={value.title}
              className="group bg-white rounded-3xl p-8 shadow-lg hover:shadow-2xl transition-all duration-500 transform hover:scale-105"
              style={{ animationDelay: `${index * 150}ms` }}
            >
              <div className="flex items-start gap-6">
                <div className="flex-shrink-0">
                  <div className="w-16 h-16 bg-gradient-to-br from-purple-500 to-blue-600 rounded-2xl flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                    <value.icon className="w-8 h-8 text-white" />
                  </div>
                </div>

                <div className="flex-1">
                  <h3 className="text-2xl font-bold text-gray-900 mb-4 group-hover:text-purple-600 transition-colors duration-300">
                    {value.title}
                  </h3>
                  <p className="text-gray-600 leading-relaxed">{value.description}</p>
                </div>
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  )
}
