"use client"

import { Shield, Eye, Lock, Users, FileText, Phone, Mail, Calendar } from "lucide-react"

export default function PrivacyPolicyContent() {
  const lastUpdated = "January 15, 2025"

  const sections = [
    {
      id: "information-collection",
      title: "Information We Collect",
      icon: Eye,
      content: [
        {
          subtitle: "Personal Information",
          text: "We collect personal information that you provide directly to us, including but not limited to your name, email address, phone number, date of birth, address, occupation, and financial information necessary for insurance underwriting and policy administration.",
        },
        {
          subtitle: "Usage Information",
          text: "We automatically collect information about how you use our website, including your IP address, browser type, operating system, referring URLs, and pages visited. This helps us improve our services and user experience.",
        },
        {
          subtitle: "Insurance-Related Information",
          text: "For insurance purposes, we may collect information about your assets, health status, driving record, claims history, and other risk-related factors as required for policy underwriting and claims processing.",
        },
      ],
    },
    {
      id: "information-use",
      title: "How We Use Your Information",
      icon: Users,
      content: [
        {
          subtitle: "Service Provision",
          text: "We use your personal information to provide insurance brokerage services, process applications, manage policies, handle claims, and communicate with you about your insurance needs.",
        },
        {
          subtitle: "Legal Compliance",
          text: "We process your information to comply with legal obligations, including anti-money laundering requirements, regulatory reporting, and other legal requirements under Nigerian law.",
        },
        {
          subtitle: "Marketing and Communication",
          text: "With your consent, we may use your information to send you marketing communications about our services, industry updates, and promotional offers. You can opt out at any time.",
        },
        {
          subtitle: "Risk Assessment",
          text: "We use your information for underwriting purposes, risk assessment, fraud prevention, and to determine appropriate insurance coverage and pricing.",
        },
      ],
    },
    {
      id: "information-sharing",
      title: "Information Sharing and Disclosure",
      icon: FileText,
      content: [
        {
          subtitle: "Insurance Partners",
          text: "We share your information with insurance companies, reinsurers, and other partners necessary to provide you with insurance coverage and process claims.",
        },
        {
          subtitle: "Service Providers",
          text: "We may share your information with trusted third-party service providers who assist us in operating our business, such as IT support, payment processors, and professional advisors.",
        },
        {
          subtitle: "Legal Requirements",
          text: "We may disclose your information when required by law, court order, or regulatory authority, or to protect our rights, property, or safety, or that of others.",
        },
        {
          subtitle: "Business Transfers",
          text: "In the event of a merger, acquisition, or sale of assets, your information may be transferred as part of the business transaction, subject to appropriate confidentiality protections.",
        },
      ],
    },
    {
      id: "data-security",
      title: "Data Security",
      icon: Lock,
      content: [
        {
          subtitle: "Security Measures",
          text: "We implement appropriate technical and organizational security measures to protect your personal information against unauthorized access, alteration, disclosure, or destruction.",
        },
        {
          subtitle: "Encryption",
          text: "We use industry-standard encryption technologies to protect sensitive information during transmission and storage, including SSL/TLS encryption for online communications.",
        },
        {
          subtitle: "Access Controls",
          text: "Access to your personal information is restricted to authorized personnel who need it to perform their job functions, and all staff are trained on data protection requirements.",
        },
        {
          subtitle: "Regular Monitoring",
          text: "We regularly monitor our systems for security vulnerabilities and update our security measures to address emerging threats and maintain the highest level of protection.",
        },
      ],
    },
    {
      id: "your-rights",
      title: "Your Rights",
      icon: Shield,
      content: [
        {
          subtitle: "Access and Correction",
          text: "You have the right to access your personal information and request corrections if it is inaccurate or incomplete. We will respond to such requests within a reasonable timeframe.",
        },
        {
          subtitle: "Data Portability",
          text: "You may request a copy of your personal information in a structured, commonly used format, and have the right to transmit this data to another service provider.",
        },
        {
          subtitle: "Deletion",
          text: "You may request deletion of your personal information, subject to legal and regulatory requirements that may require us to retain certain information for specified periods.",
        },
        {
          subtitle: "Marketing Opt-out",
          text: "You can opt out of receiving marketing communications from us at any time by clicking the unsubscribe link in our emails or contacting us directly.",
        },
      ],
    },
    {
      id: "data-retention",
      title: "Data Retention",
      icon: Calendar,
      content: [
        {
          subtitle: "Retention Periods",
          text: "We retain your personal information for as long as necessary to provide our services, comply with legal obligations, resolve disputes, and enforce our agreements.",
        },
        {
          subtitle: "Insurance Records",
          text: "Insurance-related information is typically retained for the duration of the policy period plus additional years as required by Nigerian insurance regulations and for potential claims processing.",
        },
        {
          subtitle: "Secure Disposal",
          text: "When personal information is no longer needed, we securely dispose of it using appropriate methods to prevent unauthorized access or reconstruction.",
        },
      ],
    },
  ]

  return (
    <div className="py-20">
      <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        {/* Header */}
        <div className="text-center mb-16">
          <div className="inline-flex items-center gap-2 bg-purple-100 rounded-full px-4 py-2 mb-6">
            <Shield className="w-5 h-5 text-purple-600" />
            <span className="text-purple-800 font-medium">Privacy & Data Protection</span>
          </div>

          <h1 className="text-4xl md:text-5xl font-bold mb-6">
            <span className="bg-gradient-to-r from-purple-600 to-blue-600 bg-clip-text text-transparent">
              Privacy Policy
            </span>
          </h1>

          <p className="text-xl text-gray-600 max-w-3xl mx-auto mb-8">
            At Bishop & Knight Insurance Brokers Limited, we are committed to protecting your privacy and ensuring the
            security of your personal information.
          </p>

          <div className="bg-gradient-to-r from-purple-50 to-blue-50 p-6 rounded-2xl border border-purple-200">
            <div className="flex items-center justify-center gap-2 text-purple-800">
              <Calendar className="w-5 h-5" />
              <span className="font-medium">Last Updated: {lastUpdated}</span>
            </div>
          </div>
        </div>

        {/* Introduction */}
        <div className="bg-white rounded-3xl shadow-lg p-8 mb-12">
          <h2 className="text-2xl font-bold text-gray-900 mb-6">Introduction</h2>
          <div className="prose prose-lg text-gray-600 space-y-4">
            <p>
              Bishop & Knight Insurance Brokers Limited ("we," "our," or "us") respects your privacy and is committed to
              protecting your personal information. This Privacy Policy explains how we collect, use, disclose, and
              safeguard your information when you visit our website, use our services, or interact with us.
            </p>
            <p>
              This policy applies to all information collected by Bishop & Knight Insurance Brokers Limited through our
              website, mobile applications, and other digital platforms, as well as information collected offline
              through our insurance brokerage services.
            </p>
            <p>
              By using our services or providing us with your personal information, you consent to the collection, use,
              and disclosure of your information as described in this Privacy Policy. If you do not agree with this
              policy, please do not use our services.
            </p>
          </div>
        </div>

        {/* Main Sections */}
        <div className="space-y-8">
          {sections.map((section, index) => {
            const IconComponent = section.icon
            return (
              <div key={section.id} className="bg-white rounded-3xl shadow-lg overflow-hidden">
                <div className="bg-gradient-to-r from-purple-600 to-blue-600 p-6">
                  <div className="flex items-center gap-3">
                    <div className="bg-white/20 rounded-full p-3">
                      <IconComponent className="w-6 h-6 text-white" />
                    </div>
                    <h2 className="text-2xl font-bold text-white">{section.title}</h2>
                  </div>
                </div>

                <div className="p-8">
                  <div className="space-y-6">
                    {section.content.map((item, itemIndex) => (
                      <div key={itemIndex}>
                        <h3 className="text-lg font-semibold text-gray-900 mb-3">{item.subtitle}</h3>
                        <p className="text-gray-600 leading-relaxed">{item.text}</p>
                      </div>
                    ))}
                  </div>
                </div>
              </div>
            )
          })}
        </div>

        {/* Compliance Section */}
        <div className="bg-white rounded-3xl shadow-lg p-8 mt-12">
          <h2 className="text-2xl font-bold text-gray-900 mb-6 flex items-center">
            <FileText className="w-6 h-6 text-purple-600 mr-3" />
            Legal Compliance
          </h2>
          <div className="prose prose-lg text-gray-600 space-y-4">
            <p>
              Bishop & Knight Insurance Brokers Limited operates in compliance with Nigerian data protection laws,
              including the Nigeria Data Protection Regulation (NDPR) 2019 and other applicable privacy and data
              protection legislation.
            </p>
            <p>
              We are committed to maintaining the highest standards of data protection and regularly review our
              practices to ensure ongoing compliance with evolving legal requirements.
            </p>
          </div>
        </div>

        {/* Contact Information */}
        <div className="bg-gradient-to-r from-purple-600 to-blue-600 rounded-3xl shadow-lg p-8 mt-12 text-white">
          <h2 className="text-2xl font-bold mb-6 flex items-center">
            <Phone className="w-6 h-6 mr-3" />
            Contact Us About Privacy
          </h2>
          <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
              <h3 className="text-lg font-semibold mb-3">Data Protection Officer</h3>
              <div className="space-y-2">
                <div className="flex items-center gap-2">
                  <Mail className="w-4 h-4" />
                  <a href="mailto:privacy@bishopknight.com" className="hover:underline">
                    privacy@bishopknight.com
                  </a>
                </div>
                <div className="flex items-center gap-2">
                  <Phone className="w-4 h-4" />
                  <a href="tel:+2341234567890" className="hover:underline">
                    +234 123 456 7890
                  </a>
                </div>
              </div>
            </div>
            <div>
              <h3 className="text-lg font-semibold mb-3">Office Address</h3>
              <p className="text-purple-100">
                Bishop & Knight Insurance Brokers Limited
                <br />
                123 Victoria Island
                <br />
                Lagos, Nigeria
              </p>
            </div>
          </div>
          <div className="mt-6 p-4 bg-white/10 rounded-xl">
            <p className="text-sm text-purple-100">
              If you have any questions about this Privacy Policy or our data practices, please contact us using the
              information above. We will respond to your inquiry within 30 days.
            </p>
          </div>
        </div>

        {/* Changes to Policy */}
        <div className="bg-white rounded-3xl shadow-lg p-8 mt-12">
          <h2 className="text-2xl font-bold text-gray-900 mb-6">Changes to This Privacy Policy</h2>
          <div className="prose prose-lg text-gray-600 space-y-4">
            <p>
              We may update this Privacy Policy from time to time to reflect changes in our practices, technology, legal
              requirements, or other factors. We will notify you of any material changes by posting the updated policy
              on our website and updating the "Last Updated" date.
            </p>
            <p>
              We encourage you to review this Privacy Policy periodically to stay informed about how we protect your
              information. Your continued use of our services after any changes indicates your acceptance of the updated
              policy.
            </p>
          </div>
        </div>
      </div>
    </div>
  )
}
