import { Shield, Car, Heart, Home, Plane, Users, Briefcase, TrendingUp } from "lucide-react"

const services = [
  {
    icon: Car,
    title: "Motor Insurance",
    description:
      "Comprehensive coverage for your vehicles including third-party, comprehensive, and commercial vehicle insurance.",
    features: ["Third Party Coverage", "Comprehensive Protection", "Commercial Vehicles", "Fleet Management"],
  },
  {
    icon: Heart,
    title: "Health & Life Insurance",
    description:
      "Protect your health and secure your family's future with our comprehensive health and life insurance plans.",
    features: ["Individual Health Plans", "Family Coverage", "Life Insurance", "Critical Illness Cover"],
  },
  {
    icon: Home,
    title: "Fire & General Property",
    description:
      "Safeguard your property investments against fire, theft, natural disasters, and other unforeseen events.",
    features: ["Fire Protection", "Theft Coverage", "Natural Disasters", "Property Damage"],
  },
  {
    icon: Plane,
    title: "Marine & Aviation",
    description: "Specialized coverage for marine vessels, cargo, and aviation risks with expert underwriting support.",
    features: ["Marine Hull Insurance", "Cargo Protection", "Aviation Coverage", "Transit Insurance"],
  },
  {
    icon: Shield,
    title: "Professional Indemnity",
    description: "Protect your professional practice against claims of negligence, errors, and omissions.",
    features: ["Professional Liability", "Errors & Omissions", "Legal Defense", "Reputation Protection"],
  },
  {
    icon: Users,
    title: "Group Life & Benefits",
    description: "Employee benefit packages including group life, health, and pension schemes for businesses.",
    features: ["Group Life Insurance", "Employee Health Plans", "Pension Schemes", "Disability Coverage"],
  },
  {
    icon: Briefcase,
    title: "Business Insurance",
    description:
      "Comprehensive business protection including general liability, business interruption, and cyber insurance.",
    features: ["General Liability", "Business Interruption", "Cyber Security", "Directors & Officers"],
  },
  {
    icon: TrendingUp,
    title: "Risk Advisory Services",
    description: "Bespoke risk management consulting to help identify, assess, and mitigate business risks.",
    features: ["Risk Assessment", "Management Consulting", "Compliance Support", "Strategic Planning"],
  },
]

export function ServicesGridSection() {
  return (
    <section id="services-grid" className="py-20 bg-white">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-16">
          <h2 className="text-4xl md:text-5xl font-bold bg-gradient-to-r from-purple-600 to-blue-600 bg-clip-text text-transparent mb-6">
            What We Offer
          </h2>
          <p className="text-xl text-gray-600 max-w-3xl mx-auto">
            We help you find the right coverage by working with reputable underwriters to deliver value-added solutions
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-8">
          {services.map((service, index) => (
            <div
              key={service.title}
              className="group relative bg-gradient-to-br from-white to-gray-50 rounded-2xl p-6 shadow-lg hover:shadow-2xl transition-all duration-500 transform hover:scale-105 border border-gray-100"
              style={{ animationDelay: `${index * 100}ms` }}
            >
              {/* Animated background gradient */}
              <div className="absolute inset-0 bg-gradient-to-br from-purple-500/5 to-blue-500/5 rounded-2xl opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>

              <div className="relative z-10">
                <div className="w-16 h-16 bg-gradient-to-br from-purple-500 to-blue-600 rounded-2xl flex items-center justify-center mb-4 group-hover:scale-110 transition-transform duration-300">
                  <service.icon className="w-8 h-8 text-white" />
                </div>

                <h3 className="text-xl font-bold text-gray-900 mb-3 group-hover:text-purple-600 transition-colors duration-300">
                  {service.title}
                </h3>

                <p className="text-gray-600 mb-4 leading-relaxed">{service.description}</p>

                <ul className="space-y-2">
                  {service.features.map((feature, idx) => (
                    <li key={idx} className="flex items-center text-sm text-gray-500">
                      <div className="w-1.5 h-1.5 bg-gradient-to-r from-purple-500 to-blue-500 rounded-full mr-2"></div>
                      {feature}
                    </li>
                  ))}
                </ul>

                <button className="mt-6 w-full py-2 px-4 bg-gradient-to-r from-purple-500 to-blue-600 text-white font-semibold rounded-lg opacity-0 group-hover:opacity-100 transform translate-y-2 group-hover:translate-y-0 transition-all duration-300">
                  Learn More
                </button>
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  )
}
