"use client"

import { Card, CardContent } from "@/components/ui/card"
import { Heart, Users, Award, BookOpen, Eye, Target } from "lucide-react"
import { useEffect, useState } from "react"

const coreValues = [
  {
    icon: Heart,
    title: "Integrity",
    description:
      "Unwavering honesty and transparency in every interaction, building trust through ethical practices and authentic relationships.",
    gradient: "from-red-500 to-pink-500",
    bg: "from-red-50 to-pink-50",
  },
  {
    icon: Users,
    title: "Teamwork",
    description:
      "Collaborative excellence where diverse talents unite to create innovative solutions and exceptional customer experiences.",
    gradient: "from-blue-500 to-cyan-500",
    bg: "from-blue-50 to-cyan-50",
  },
  {
    icon: Award,
    title: "Professionalism",
    description:
      "Setting the highest standards in service delivery, expertise, and industry knowledge to exceed client expectations.",
    gradient: "from-purple-500 to-indigo-500",
    bg: "from-purple-50 to-indigo-50",
  },
  {
    icon: BookOpen,
    title: "Continuous Learning",
    description:
      "Embracing growth mindset and innovation to stay ahead of industry trends and deliver cutting-edge solutions.",
    gradient: "from-green-500 to-teal-500",
    bg: "from-green-50 to-teal-50",
  },
]

export function ValuesSection() {
  const [isVisible, setIsVisible] = useState(false)

  useEffect(() => {
    const observer = new IntersectionObserver(
      ([entry]) => {
        if (entry.isIntersecting) {
          setIsVisible(true)
        }
      },
      { threshold: 0.1 },
    )

    const element = document.getElementById("values")
    if (element) observer.observe(element)

    return () => observer.disconnect()
  }, [])

  return (
    <section
      id="values"
      className="py-20 bg-gradient-to-br from-slate-50 via-purple-50/30 to-blue-50/30 relative overflow-hidden"
    >
      {/* Background Elements */}
      <div className="absolute inset-0 overflow-hidden">
        <div className="absolute top-20 left-20 w-80 h-80 bg-gradient-to-r from-purple-200/30 to-blue-200/30 rounded-full blur-3xl animate-pulse"></div>
        <div className="absolute bottom-20 right-20 w-72 h-72 bg-gradient-to-r from-cyan-200/30 to-teal-200/30 rounded-full blur-3xl animate-pulse animation-delay-2000"></div>
      </div>

      <div className="container mx-auto px-4 relative z-10">
        <div
          className={`text-center mb-16 transition-all duration-1000 ${isVisible ? "opacity-100 translate-y-0" : "opacity-0 translate-y-10"}`}
        >
          <div className="inline-flex items-center px-6 py-3 bg-gradient-to-r from-purple-100 to-blue-100 text-purple-800 rounded-full text-sm font-medium border border-purple-200/50 mb-6">
            <Heart className="h-4 w-4 mr-2 animate-pulse" />
            Our Core Values
          </div>

          <h2 className="text-4xl lg:text-5xl font-bold mb-6">
            <span className="bg-gradient-to-r from-purple-600 to-blue-600 bg-clip-text text-transparent">
              Values That
            </span>
            <br />
            <span className="text-slate-900">Drive Excellence</span>
          </h2>

          <p className="text-xl text-slate-600 max-w-3xl mx-auto leading-relaxed">
            Our core values are the foundation of everything we do, guiding our decisions and shaping our culture of
            innovation and excellence.
          </p>
        </div>

        <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8 mb-16">
          {coreValues.map((value, index) => (
            <Card
              key={index}
              className={`group hover:shadow-2xl transition-all duration-500 border-0 shadow-lg hover:-translate-y-3 bg-gradient-to-br ${value.bg} backdrop-blur-sm overflow-hidden ${
                isVisible ? "opacity-100 translate-y-0" : "opacity-0 translate-y-10"
              }`}
              style={{ transitionDelay: `${index * 150}ms` }}
            >
              <CardContent className="p-8 text-center relative">
                <div
                  className={`absolute inset-0 bg-gradient-to-r ${value.gradient} opacity-0 group-hover:opacity-5 transition-opacity duration-300`}
                ></div>
                <div className="relative z-10">
                  <div
                    className={`inline-flex items-center justify-center w-16 h-16 rounded-2xl bg-gradient-to-r ${value.gradient} mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg`}
                  >
                    <value.icon className="h-8 w-8 text-white" />
                  </div>
                  <h3 className="text-xl font-bold text-slate-900 mb-4 group-hover:text-purple-700 transition-colors duration-300">
                    {value.title}
                  </h3>
                  <p className="text-slate-600 leading-relaxed text-sm">{value.description}</p>
                </div>
              </CardContent>
            </Card>
          ))}
        </div>

        {/* Mission & Vision */}
        <div
          className={`grid lg:grid-cols-2 gap-8 transition-all duration-1000 delay-600 ${isVisible ? "opacity-100 translate-y-0" : "opacity-0 translate-y-10"}`}
        >
          <Card className="bg-gradient-to-br from-purple-600 to-blue-600 text-white border-0 shadow-2xl overflow-hidden relative group">
            <div className="absolute inset-0 bg-gradient-to-r from-white/10 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
            <CardContent className="p-8 relative z-10">
              <div className="flex items-center mb-6">
                <div className="p-3 bg-white/20 backdrop-blur-sm rounded-xl mr-4">
                  <Eye className="h-8 w-8 text-white" />
                </div>
                <h3 className="text-2xl font-bold">Our Vision</h3>
              </div>
              <p className="text-blue-100 text-lg leading-relaxed">
                To be Africa's most innovative insurance technology platform, empowering millions with accessible,
                intelligent protection that evolves with their needs and dreams.
              </p>
            </CardContent>
          </Card>

          <Card className="bg-gradient-to-br from-green-600 to-teal-600 text-white border-0 shadow-2xl overflow-hidden relative group">
            <div className="absolute inset-0 bg-gradient-to-r from-white/10 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
            <CardContent className="p-8 relative z-10">
              <div className="flex items-center mb-6">
                <div className="p-3 bg-white/20 backdrop-blur-sm rounded-xl mr-4">
                  <Target className="h-8 w-8 text-white" />
                </div>
                <h3 className="text-2xl font-bold">Our Mission</h3>
              </div>
              <p className="text-green-100 text-lg leading-relaxed">
                Revolutionizing insurance through technology, transparency, and exceptional customer experience while
                building lasting partnerships that protect what matters most to Nigerians.
              </p>
            </CardContent>
          </Card>
        </div>
      </div>
    </section>
  )
}
