"use client"

import { Card, CardContent } from "@/components/ui/card"
import { Button } from "@/components/ui/button"
import { Zap, Shield, Users, TrendingUp, Award, Heart, ArrowRight } from "lucide-react"
import { useEffect, useState } from "react"

const differentiators = [
  {
    icon: Zap,
    title: "Lightning-Fast Technology",
    description: "AI-powered platforms delivering instant quotes, real-time claims tracking, and 24-hour settlements.",
    gradient: "from-yellow-500 to-orange-500",
    bg: "from-yellow-50 to-orange-50",
  },
  {
    icon: Shield,
    title: "Unmatched Security",
    description: "Blockchain-secured data protection and military-grade encryption for complete peace of mind.",
    gradient: "from-blue-500 to-cyan-500",
    bg: "from-blue-50 to-cyan-50",
  },
  {
    icon: Users,
    title: "Personal Relationship Managers",
    description: "Dedicated experts who understand your unique needs and provide personalized guidance.",
    gradient: "from-green-500 to-teal-500",
    bg: "from-green-50 to-teal-50",
  },
  {
    icon: TrendingUp,
    title: "Transparent Pricing",
    description: "No hidden fees, clear terms, and competitive rates with detailed breakdowns of all costs.",
    gradient: "from-purple-500 to-indigo-500",
    bg: "from-purple-50 to-indigo-50",
  },
  {
    icon: Award,
    title: "Industry Leadership",
    description: "Award-winning innovation and recognized excellence in customer service and technology.",
    gradient: "from-pink-500 to-red-500",
    bg: "from-pink-50 to-red-50",
  },
  {
    icon: Heart,
    title: "Community Impact",
    description:
      "Committed to supporting Nigerian communities through education, healthcare, and economic development.",
    gradient: "from-cyan-500 to-blue-500",
    bg: "from-cyan-50 to-blue-50",
  },
]

export function WhyChooseAboutSection() {
  const [isVisible, setIsVisible] = useState(false)

  useEffect(() => {
    const observer = new IntersectionObserver(
      ([entry]) => {
        if (entry.isIntersecting) {
          setIsVisible(true)
        }
      },
      { threshold: 0.1 },
    )

    const element = document.getElementById("why-choose-about")
    if (element) observer.observe(element)

    return () => observer.disconnect()
  }, [])

  return (
    <section
      id="why-choose-about"
      className="py-20 bg-gradient-to-br from-white via-purple-50/20 to-blue-50/20 relative overflow-hidden"
    >
      {/* Background Elements */}
      <div className="absolute inset-0 overflow-hidden">
        <div className="absolute top-32 right-20 w-80 h-80 bg-gradient-to-r from-purple-300/20 to-blue-300/20 rounded-full blur-3xl animate-blob"></div>
        <div className="absolute bottom-32 left-20 w-72 h-72 bg-gradient-to-r from-cyan-300/20 to-teal-300/20 rounded-full blur-3xl animate-blob animation-delay-2000"></div>
      </div>

      <div className="container mx-auto px-4 relative z-10">
        <div
          className={`text-center mb-16 transition-all duration-1000 ${isVisible ? "opacity-100 translate-y-0" : "opacity-0 translate-y-10"}`}
        >
          <div className="inline-flex items-center px-6 py-3 bg-gradient-to-r from-purple-100 to-blue-100 text-purple-800 rounded-full text-sm font-medium border border-purple-200/50 mb-6">
            <TrendingUp className="h-4 w-4 mr-2 animate-pulse" />
            Why Choose Bishop & Knight
          </div>

          <h2 className="text-4xl lg:text-5xl font-bold mb-6">
            <span className="bg-gradient-to-r from-purple-600 to-blue-600 bg-clip-text text-transparent">
              The Bishop & Knight
            </span>
            <br />
            <span className="text-slate-900">Advantage</span>
          </h2>

          <p className="text-xl text-slate-600 max-w-3xl mx-auto leading-relaxed">
            Discover what sets us apart in Nigeria's insurance landscape and why thousands of clients trust us with
            their most valuable assets.
          </p>
        </div>

        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8 mb-16">
          {differentiators.map((item, index) => (
            <Card
              key={index}
              className={`group hover:shadow-2xl transition-all duration-500 border-0 shadow-lg hover:-translate-y-3 bg-gradient-to-br ${item.bg} backdrop-blur-sm overflow-hidden ${
                isVisible ? "opacity-100 translate-y-0" : "opacity-0 translate-y-10"
              }`}
              style={{ transitionDelay: `${index * 150}ms` }}
            >
              <CardContent className="p-8 text-center relative">
                <div
                  className={`absolute inset-0 bg-gradient-to-r ${item.gradient} opacity-0 group-hover:opacity-5 transition-opacity duration-300`}
                ></div>
                <div className="relative z-10">
                  <div
                    className={`inline-flex items-center justify-center w-16 h-16 rounded-2xl bg-gradient-to-r ${item.gradient} mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg`}
                  >
                    <item.icon className="h-8 w-8 text-white" />
                  </div>
                  <h3 className="text-xl font-bold text-slate-900 mb-4 group-hover:text-purple-700 transition-colors duration-300">
                    {item.title}
                  </h3>
                  <p className="text-slate-600 leading-relaxed">{item.description}</p>
                </div>
              </CardContent>
            </Card>
          ))}
        </div>

        {/* CTA Section */}
        <div
          className={`transition-all duration-1000 delay-600 ${isVisible ? "opacity-100 translate-y-0" : "opacity-0 translate-y-10"}`}
        >
          <Card className="bg-gradient-to-r from-purple-600 via-blue-600 to-cyan-600 text-white border-0 shadow-2xl overflow-hidden relative group">
            <div className="absolute inset-0 bg-gradient-to-r from-white/10 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
            <CardContent className="p-12 text-center relative z-10">
              <div className="max-w-3xl mx-auto">
                <h3 className="text-3xl font-bold mb-6">Ready to Experience the Difference?</h3>
                <p className="text-blue-100 text-lg mb-8 leading-relaxed">
                  Join thousands of satisfied clients who have discovered the future of insurance with Bishop & Knight.
                  Get your personalized quote in under 60 seconds.
                </p>
                <div className="flex flex-col sm:flex-row gap-4 justify-center">
                  <Button
                    size="lg"
                    variant="secondary"
                    className="bg-white text-purple-600 hover:bg-slate-100 px-8 py-4 text-lg rounded-full font-semibold group transition-all duration-300"
                  >
                    <Zap className="mr-2 h-5 w-5 group-hover:animate-pulse" />
                    Get Instant Quote
                  </Button>
                  <Button
                    size="lg"
                    variant="outline"
                    className="border-2 border-white/50 text-white hover:bg-white/10 px-8 py-4 text-lg rounded-full font-semibold backdrop-blur-sm transition-all duration-300 bg-transparent"
                  >
                    <Users className="mr-2 h-5 w-5" />
                    Talk to Expert
                    <ArrowRight className="ml-2 h-5 w-5 group-hover:translate-x-1 transition-transform duration-300" />
                  </Button>
                </div>
              </div>
            </CardContent>
          </Card>
        </div>
      </div>
    </section>
  )
}
