"use client"

import { Card, CardContent } from "@/components/ui/card"
import { Button } from "@/components/ui/button"
import { Search, Briefcase, Smartphone, Clock, Shield, Award, Zap, TrendingUp } from "lucide-react"
import { useEffect, useState } from "react"
import { GlowingCard } from "@/components/ui/glowing-card"

const features = [
  {
    icon: Search,
    title: "AI-Powered Matching",
    description: "Smart algorithms analyze your profile to find the perfect insurance match in seconds.",
    gradient: "from-blue-500 to-cyan-500",
    bg: "from-blue-50 to-cyan-50",
  },
  {
    icon: Briefcase,
    title: "Market Leadership",
    description: "Exclusive partnerships with Nigeria's top insurers for unbeatable rates and coverage.",
    gradient: "from-green-500 to-emerald-500",
    bg: "from-green-50 to-emerald-50",
  },
  {
    icon: Smartphone,
    title: "Mobile-First Experience",
    description: "Manage everything from your phone - quotes, claims, renewals, and support.",
    gradient: "from-purple-500 to-pink-500",
    bg: "from-purple-50 to-pink-50",
  },
  {
    icon: Clock,
    title: "Lightning Fast Claims",
    description: "AI-assisted claims processing with 24-hour settlement for approved claims.",
    gradient: "from-orange-500 to-red-500",
    bg: "from-orange-50 to-red-50",
  },
  {
    icon: Shield,
    title: "Blockchain Security",
    description: "Your data protected by military-grade encryption and blockchain technology.",
    gradient: "from-cyan-500 to-teal-500",
    bg: "from-cyan-50 to-teal-50",
  },
  {
    icon: Award,
    title: "Customer Obsession",
    description: "99.8% satisfaction rate with dedicated relationship managers for every client.",
    gradient: "from-indigo-500 to-purple-500",
    bg: "from-indigo-50 to-purple-50",
  },
]

export function WhyChooseUsSection() {
  const [isVisible, setIsVisible] = useState(false)

  useEffect(() => {
    const observer = new IntersectionObserver(
      ([entry]) => {
        if (entry.isIntersecting) {
          setIsVisible(true)
        }
      },
      { threshold: 0.1 },
    )

    const element = document.getElementById("why-choose-us")
    if (element) observer.observe(element)

    return () => observer.disconnect()
  }, [])

  return (
    <section
      id="why-choose-us"
      className="py-20 bg-gradient-to-br from-slate-900 via-purple-900 to-blue-900 relative overflow-hidden"
    >
      {/* Background Elements */}
      <div className="absolute inset-0 overflow-hidden">
        <div className="absolute top-20 left-10 w-64 h-64 bg-gradient-to-r from-orange-300/20 to-pink-300/20 rounded-full blur-3xl animate-blob"></div>
        <div className="absolute bottom-20 right-10 w-72 h-72 bg-gradient-to-r from-yellow-300/20 to-red-300/20 rounded-full blur-3xl animate-blob animation-delay-2000"></div>
      </div>

      <div className="container mx-auto px-4 relative z-10">
        <div
          className={`text-center mb-16 transition-all duration-1000 ${isVisible ? "opacity-100 translate-y-0" : "opacity-0 translate-y-10"}`}
        >
          <div className="inline-flex items-center px-6 py-3 bg-gradient-to-r from-orange-500/20 to-pink-500/20 text-orange-200 rounded-full text-sm font-medium border border-orange-400/30 mb-6 backdrop-blur-sm">
            <TrendingUp className="h-4 w-4 mr-2 animate-pulse" />
            Why Choose Bishop & Knight?
          </div>

          <h2 className="text-4xl lg:text-5xl font-bold mb-6">
            <span className="bg-gradient-to-r from-orange-400 to-pink-400 bg-clip-text text-transparent">
              The Future of Insurance
            </span>
            <br />
            <span className="text-white">Is Here Today</span>
          </h2>

          <p className="text-xl text-slate-300 max-w-3xl mx-auto leading-relaxed">
            Experience insurance reimagined with cutting-edge technology, unmatched expertise, and customer-first
            innovation.
          </p>
        </div>

        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8 mb-16">
          {features.map((feature, index) => (
            <GlowingCard
              key={index}
              className={`${isVisible ? "opacity-100 translate-y-0" : "opacity-0 translate-y-10"}`}
              style={{ transitionDelay: `${index * 100}ms` }}
            >
              <div className="text-center p-8">
                <div className="inline-flex items-center justify-center w-16 h-16 rounded-2xl bg-gradient-to-r from-orange-500 to-pink-500 mb-6 shadow-lg">
                  <feature.icon className="h-8 w-8 text-white" />
                </div>
                <h3 className="text-xl font-bold text-white mb-4">{feature.title}</h3>
                <p className="text-slate-300 leading-relaxed">{feature.description}</p>
              </div>
            </GlowingCard>
          ))}
        </div>

        {/* Claims Highlight Section */}
        <div
          className={`transition-all duration-1000 delay-600 ${isVisible ? "opacity-100 translate-y-0" : "opacity-0 translate-y-10"}`}
        >
          <Card className="bg-gradient-to-r from-slate-900 via-purple-900 to-blue-900 text-white border-0 shadow-2xl overflow-hidden relative group">
            <div className="absolute inset-0 bg-gradient-to-r from-white/5 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
            <CardContent className="p-12 relative z-10">
              <div className="grid lg:grid-cols-2 gap-12 items-center">
                <div>
                  <div className="flex items-center mb-6">
                    <div className="p-3 bg-gradient-to-r from-purple-500 to-blue-500 rounded-xl mr-4">
                      <Zap className="h-8 w-8 text-white" />
                    </div>
                    <h3 className="text-3xl font-bold">Claims Revolution</h3>
                  </div>

                  <p className="text-xl text-blue-100 mb-8 leading-relaxed">
                    Experience the fastest, most transparent claims process in Nigeria. Our AI-powered system processes
                    claims 10x faster than traditional methods.
                  </p>

                  <div className="space-y-4 mb-8">
                    {[
                      "Instant claim submission via mobile app",
                      "AI damage assessment in under 5 minutes",
                      "Real-time claim tracking and updates",
                      "24-hour settlement for approved claims",
                    ].map((item, index) => (
                      <div key={index} className="flex items-center space-x-3">
                        <div className="w-2 h-2 bg-gradient-to-r from-purple-400 to-blue-400 rounded-full animate-pulse"></div>
                        <span className="text-blue-100">{item}</span>
                      </div>
                    ))}
                  </div>

                  <Button className="bg-white text-purple-600 hover:bg-slate-100 px-8 py-3 rounded-full font-semibold group transition-all duration-300">
                    <Shield className="mr-2 h-5 w-5 group-hover:animate-pulse" />
                    Try Claims Demo
                  </Button>
                </div>

                <div className="relative">
                  <img
                    src="https://images.unsplash.com/photo-1551434678-e076c223a692?w=500&h=400&fit=crop&crop=center"
                    alt="Modern claims processing technology"
                    className="w-full h-auto rounded-2xl shadow-2xl"
                  />
                  <div className="absolute inset-0 bg-gradient-to-t from-purple-900/30 to-transparent rounded-2xl"></div>

                  {/* Floating Stats */}
                  <div className="absolute -top-4 -right-4 bg-white/90 backdrop-blur-xl p-4 rounded-xl shadow-xl animate-float">
                    <div className="text-center">
                      <div className="text-2xl font-bold text-purple-600">24hrs</div>
                      <div className="text-xs text-slate-600">Avg Settlement</div>
                    </div>
                  </div>

                  <div className="absolute -bottom-4 -left-4 bg-white/90 backdrop-blur-xl p-4 rounded-xl shadow-xl animate-float animation-delay-1000">
                    <div className="text-center">
                      <div className="text-2xl font-bold text-blue-600">99.8%</div>
                      <div className="text-xs text-slate-600">Satisfaction</div>
                    </div>
                  </div>
                </div>
              </div>
            </CardContent>
          </Card>
        </div>
      </div>
    </section>
  )
}
