// Database Schema for Bishop & Knight Insurance CMS

export interface SiteContent {
  id: string
  createdAt: Date
  updatedAt: Date
}

// Hero Section Content
export interface HeroContent extends SiteContent {
  title: string
  subtitle: string
  ctaText: string
  ctaLink: string
  backgroundVideo?: string
  backgroundImage?: string
  stats: {
    experience: { number: string; label: string }
    clients: { number: string; label: string }
    support: { number: string; label: string }
  }
}

// About Section Content
export interface AboutContent extends SiteContent {
  title: string
  subtitle: string
  description: string
  mission: string
  vision: string
  values: Array<{
    title: string
    description: string
    icon: string
  }>
  achievements: Array<{
    number: string
    label: string
    description: string
  }>
}

// Services Content
export interface ServiceContent extends SiteContent {
  title: string
  description: string
  icon: string
  features: string[]
  pricing?: {
    type: 'fixed' | 'percentage' | 'permille'
    value: number
    baseDescription: string
  }
  category: 'motor' | 'property' | 'marine' | 'professional' | 'group-life' | 'business' | 'advisory'
  isActive: boolean
}

// Team Member Content
export interface TeamMember extends SiteContent {
  name: string
  position: string
  department: string
  bio: string
  image: string
  email?: string
  linkedin?: string
  isExecutive: boolean
  displayOrder: number
}

// Contact Information
export interface ContactInfo extends SiteContent {
  companyName: string
  tagline: string
  phone: string
  email: string
  address: string
  socialMedia: {
    facebook?: string
    twitter?: string
    linkedin?: string
    instagram?: string
  }
  businessHours: {
    weekdays: string
    weekends: string
  }
}

// Media Assets
export interface MediaAsset extends SiteContent {
  filename: string
  originalName: string
  mimeType: string
  size: number
  url: string
  alt?: string
  category: 'image' | 'video' | 'document'
  isPublic: boolean
}

// Site Settings
export interface SiteSettings extends SiteContent {
  theme: {
    primaryColor: string
    secondaryColor: string
    accentColor: string
    backgroundColor: string
    textColor: string
  }
  fonts: {
    heading: string
    body: string
  }
  seo: {
    title: string
    description: string
    keywords: string[]
    ogImage?: string
  }
  analytics: {
    googleAnalyticsId?: string
    facebookPixelId?: string
  }
  maintenance: {
    enabled: boolean
    message?: string
  }
}

// User Management
export interface User extends SiteContent {
  username: string
  email: string
  passwordHash: string
  role: 'admin' | 'editor' | 'viewer'
  isActive: boolean
  lastLogin?: Date
  permissions: string[]
}

// Quote Requests (from website)
export interface QuoteRequest extends SiteContent {
  customerName: string
  customerEmail: string
  customerPhone: string
  insuranceType: string
  coverageAmount: number
  additionalDetails: string
  status: 'pending' | 'processed' | 'quoted' | 'converted' | 'rejected'
  assignedTo?: string
  notes?: string
  quotedAmount?: number
  quotedBy?: string
  quotedAt?: Date
}